/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.CustomStatusRetryException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    public static final CustomHttpRequestRetryHandler INSTANCE = new CustomHttpRequestRetryHandler();
    public static final String RETRY_ATTRIBUTE = "dmc-sdk:retry";
    private static final Logger logger = LoggerFactory.getLogger(CustomHttpRequestRetryHandler.class);
    private static final long RETRY_INTERVAL_TIME = 100L;
    private static final Map<String, Boolean> idempotentMethods = new ConcurrentHashMap<String, Boolean>();
    private static final Set<Class<? extends IOException>> nonRetriableClasses;
    private final int retryCount;
    private final boolean requestSentRetryEnabled;

    public CustomHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
    }

    public CustomHttpRequestRetryHandler() {
        this(3, false);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        if (executionCount > this.retryCount) {
            return false;
        }
        if (nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.handleAsIdempotent(request)) {
            return this.trueDelayReturn(exception, request, executionCount);
        }
        if (exception instanceof CustomStatusRetryException && Boolean.TRUE.equals(context.getAttribute(RETRY_ATTRIBUTE))) {
            return this.trueDelayReturn(exception, request, executionCount);
        }
        if (!clientContext.isRequestSent() || this.requestSentRetryEnabled) {
            return this.trueDelayReturn(exception, request, executionCount);
        }
        return false;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ROOT);
        return idempotentMethods.containsKey(method);
    }

    protected boolean trueDelayReturn(IOException exception, HttpRequest request, int executionCount) {
        try {
            long sleep = (long)executionCount * 100L;
            logger.warn("Retry request, execution count: {}, sleep: {}ms, uri: {}, exception: {}", new Object[]{executionCount, sleep, request.getRequestLine(), exception.getMessage()});
            TimeUnit.MILLISECONDS.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    static {
        idempotentMethods.put(HttpMethod.GET.name(), Boolean.TRUE);
        idempotentMethods.put(HttpMethod.HEAD.name(), Boolean.TRUE);
        idempotentMethods.put(HttpMethod.PUT.name(), Boolean.TRUE);
        idempotentMethods.put(HttpMethod.DELETE.name(), Boolean.TRUE);
        idempotentMethods.put(HttpMethod.OPTIONS.name(), Boolean.TRUE);
        idempotentMethods.put(HttpMethod.TRACE.name(), Boolean.TRUE);
        nonRetriableClasses = new HashSet<Class<? extends IOException>>();
        nonRetriableClasses.add(InterruptedIOException.class);
        nonRetriableClasses.add(UnknownHostException.class);
        nonRetriableClasses.add(ConnectException.class);
        nonRetriableClasses.add(SSLException.class);
    }
}

