/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.common.utils.ResourceManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class DMCUtils {
    public static final ResourceManager DMC_RESOURCE_MANAGER = ResourceManager.getInstance("i18n/dmc");
    public static final ResourceManager COMMON_RESOURCE_MANAGER = ResourceManager.getInstance("i18n/common");
    private static final String BUCKET_NAMING_CREATION_REGEX = "^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$";
    private static final String BUCKET_NAMING_REGEX = "^[a-z0-9][a-z0-9-_]{1,61}[a-z0-9]$";
    private static final String ENDPOINT_REGEX = "^[a-zA-Z0-9._-]+$";

    public static boolean validateEndpoint(String endpoint) {
        if (endpoint == null) {
            return false;
        }
        return endpoint.matches(ENDPOINT_REGEX);
    }

    public static void ensureEndpointValid(String endpoint) {
        if (!DMCUtils.validateEndpoint(endpoint)) {
            throw new IllegalArgumentException(DMC_RESOURCE_MANAGER.getFormattedString("EndpointInvalid", endpoint));
        }
    }

    public static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        return bucketName.matches(BUCKET_NAMING_REGEX);
    }

    public static void ensureBucketNameValid(String bucketName) {
        if (!DMCUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException(DMC_RESOURCE_MANAGER.getFormattedString("BucketNameInvalid", bucketName));
        }
    }

    public static boolean validateBucketNameCreation(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        return bucketName.matches(BUCKET_NAMING_CREATION_REGEX);
    }

    public static void ensureBucketNameCreationValid(String bucketName) {
        if (!DMCUtils.validateBucketNameCreation(bucketName)) {
            throw new IllegalArgumentException(DMC_RESOURCE_MANAGER.getFormattedString("BucketNameInvalid", bucketName));
        }
    }

    public static boolean validateObjectKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        byte[] bytes = null;
        try {
            bytes = key.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        char[] keyChars = key.toCharArray();
        char firstChar = keyChars[0];
        if (firstChar == '\\') {
            return false;
        }
        return bytes.length > 0 && bytes.length < 1024;
    }

    public static void ensureObjectKeyValid(String key) {
        if (!DMCUtils.validateObjectKey(key)) {
            throw new IllegalArgumentException(DMC_RESOURCE_MANAGER.getFormattedString("ObjectKeyInvalid", key));
        }
    }

    public static void ensureLiveChannelNameValid(String liveChannelName) {
        if (!DMCUtils.validateObjectKey(liveChannelName)) {
            throw new IllegalArgumentException(DMC_RESOURCE_MANAGER.getFormattedString("LiveChannelNameInvalid", liveChannelName));
        }
    }

    private static boolean cnameExcludeFilter(String hostToFilter, List<String> excludeList) {
        if (hostToFilter != null && !hostToFilter.trim().isEmpty()) {
            String canonicalHost = hostToFilter.toLowerCase();
            for (String excl : excludeList) {
                if (!canonicalHost.endsWith(excl)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Host name can not be null.");
    }

    public static void safeCloseResponse(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

