/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.client;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.utils.StreamUtils;
import com.digiwin.dap.middleware.dmc.internal.client.OSS;
import com.digiwin.dap.middleware.dmc.internal.client.model.ShareV1Request;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadPartV1Request;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadV1Request;
import com.digiwin.dap.middleware.dmc.internal.client.operation.DeleteV1Operation;
import com.digiwin.dap.middleware.dmc.internal.client.operation.DirInfoV1Operation;
import com.digiwin.dap.middleware.dmc.internal.client.operation.DownloadV1Operation;
import com.digiwin.dap.middleware.dmc.internal.client.operation.FileInfoV1Operation;
import com.digiwin.dap.middleware.dmc.internal.client.operation.ShareV1Operation;
import com.digiwin.dap.middleware.dmc.internal.client.operation.UploadV1Operation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCBucketOperation;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;
import com.digiwin.dap.middleware.dmc.model.Bucket;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.DirRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadPartRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;
import com.digiwin.dap.middleware.dmc.model.FolderInfo;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class OSSClient
implements OSS {
    protected ServiceClient serviceClient;
    private UploadV1Operation uploadV1Operation;
    private DownloadV1Operation downloadV1Operation;
    private DeleteV1Operation deleteV1Operation;
    private ShareV1Operation shareV1Operation;
    private DirInfoV1Operation dirInfoV1Operation;
    private FileInfoV1Operation fileInfoV1Operation;
    private DMCBucketOperation dmcBucketOperation;

    protected void initOperations() {
        this.uploadV1Operation = new UploadV1Operation(this.serviceClient);
        this.downloadV1Operation = new DownloadV1Operation(this.serviceClient);
        this.deleteV1Operation = new DeleteV1Operation(this.serviceClient);
        this.shareV1Operation = new ShareV1Operation(this.serviceClient);
        this.dirInfoV1Operation = new DirInfoV1Operation(this.serviceClient);
        this.fileInfoV1Operation = new FileInfoV1Operation(this.serviceClient);
        this.dmcBucketOperation = new DMCBucketOperation(this.serviceClient);
    }

    @Override
    public FileInfo uploadV1(InputStream input, FileInfo fileInfo) {
        UploadV1Request request = new UploadV1Request();
        request.setInput(input);
        request.setFileInfo(fileInfo);
        return this.uploadV1(request);
    }

    @Override
    public FileInfo uploadV1(UploadV1Request request) {
        try {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Bucket bucket = this.dmcBucketOperation.getBucketInfoByName();
            if (iamUserToken != null && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.setContext(iamUserToken);
            }
            request.setPublicKey(bucket.getPublicKey());
            return this.uploadV1Operation.upload(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public FileInfo uploadCoverV1(String fileId, InputStream input) {
        UploadV1Request request = new UploadV1Request();
        request.setInput(input);
        request.setFileId(fileId);
        return this.uploadCoverV1(request);
    }

    @Override
    public FileInfo uploadCoverV1(UploadV1Request request) {
        try {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Bucket bucket = this.dmcBucketOperation.getBucketInfoByName();
            if (iamUserToken != null && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.setContext(iamUserToken);
            }
            request.setPublicKey(bucket.getPublicKey());
            return this.uploadV1Operation.uploadCover(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public ShareInfo uploadShareV1(InputStream input, FileInfo fileInfo) {
        UploadV1Request request = new UploadV1Request();
        request.setInput(input);
        request.setFileInfo(fileInfo);
        return this.uploadShareV1(request);
    }

    @Override
    public ShareInfo uploadShareV1(UploadV1Request request) {
        try {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Bucket bucket = this.dmcBucketOperation.getBucketInfoByName();
            if (iamUserToken != null && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.setContext(iamUserToken);
            }
            request.setPublicKey(bucket.getPublicKey());
            return this.uploadV1Operation.uploadShare(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String claimFileIdV1(UploadPartV1Request request) {
        try {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Bucket bucket = this.dmcBucketOperation.getBucketInfoByName();
            if (iamUserToken != null && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.setContext(iamUserToken);
            }
            request.setPublicKey(bucket.getPublicKey());
            return this.uploadV1Operation.claimFileId(request).getId();
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String uploadPartV1(UploadPartV1Request request) {
        try {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Bucket bucket = this.dmcBucketOperation.getBucketInfoByName();
            if (iamUserToken != null && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.setContext(iamUserToken);
            }
            request.setPublicKey(bucket.getPublicKey());
            return this.uploadV1Operation.uploadPart(request).getId();
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String uploadPartCoverV1(UploadPartV1Request request) {
        try {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Bucket bucket = this.dmcBucketOperation.getBucketInfoByName();
            if (iamUserToken != null && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.setContext(iamUserToken);
            }
            request.setPublicKey(bucket.getPublicKey());
            return this.uploadV1Operation.uploadPartCover(request).getId();
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void downloadV1(String fileId, OutputStream output) {
        DownloadRequest request = new DownloadRequest();
        request.setFileId(fileId);
        request.setOutput(output);
        this.downloadV1(request);
    }

    @Override
    public byte[] downloadV1(DownloadRequest request) {
        try {
            byte[] bytes = this.downloadV1Operation.download(request);
            if (request.getOutput() != null) {
                StreamUtils.copy(bytes, request.getOutput());
            }
            return bytes;
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public byte[] downloadPartV1(DownloadPartRequest request) {
        try {
            byte[] bytes = this.downloadV1Operation.downloadPart(request);
            StreamUtils.copy(bytes, request.getOutput());
            return bytes;
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String removeV1(String fileId) {
        BatchRequest request = new BatchRequest();
        request.setFileId(fileId);
        return this.removeV1(request);
    }

    @Override
    public String removeV1(BatchRequest request) {
        try {
            return this.deleteV1Operation.delete(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String removeDirV1(String dirId) {
        BatchRequest request = new BatchRequest();
        request.setDirId(dirId);
        return this.removeDirV1(request);
    }

    @Override
    public String removeDirV1(BatchRequest request) {
        try {
            return this.deleteV1Operation.deleteDir(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void batchRemoveV1(List<String> fileIds, List<String> dirIds) {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        this.batchRemoveV1(request);
    }

    @Override
    public void batchRemoveV1(BatchRequest request) {
        try {
            this.deleteV1Operation.deleteMulti(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void deleteV1(String fileId) {
        BatchRequest request = new BatchRequest();
        request.setFileId(fileId);
        this.deleteV1(request);
    }

    @Override
    public void deleteV1(BatchRequest request) {
        try {
            this.deleteV1Operation.deleteForce(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String shareV1(String fileId) {
        List<String> shareUrls = this.shareV1(Collections.singletonList(fileId));
        return shareUrls.isEmpty() ? null : shareUrls.get(0);
    }

    @Override
    public List<String> shareV1(List<String> fileIds) {
        ShareV1Request request = new ShareV1Request();
        request.setFileIds(fileIds);
        return this.shareV1(request);
    }

    @Override
    public List<String> shareV1(List<String> fileIds, long expireDay) {
        ShareV1Request request = new ShareV1Request();
        request.setFileIds(fileIds);
        request.setExpireDay(expireDay);
        return this.shareV1(request);
    }

    @Override
    public List<String> shareV1(ShareV1Request request) {
        try {
            if (request.getExpireDay() > 0L) {
                return this.shareV1Operation.shareDay(request);
            }
            return this.shareV1Operation.share(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void deleteShareV1(String shareId) {
        ShareV1Request request = new ShareV1Request();
        request.setShareId(shareId);
        this.deleteShareV1(request);
    }

    @Override
    public void deleteShareV1(ShareV1Request request) {
        try {
            this.shareV1Operation.deleteShare(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String copyV1(String fileId, String targetDirId) {
        FileOpRequest request = new FileOpRequest();
        request.setFileId(fileId);
        request.setTargetDirId(targetDirId);
        return this.copyV1(request);
    }

    @Override
    public String copyV1(FileOpRequest request) {
        try {
            return this.fileInfoV1Operation.copyFile(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String copyDirV1(String dirId, String targetDirId) {
        FileOpRequest request = new FileOpRequest();
        request.setDirId(dirId);
        request.setTargetDirId(targetDirId);
        return this.copyDirV1(request);
    }

    @Override
    public String copyDirV1(FileOpRequest request) {
        try {
            return this.dirInfoV1Operation.copyDir(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void batchCopyV1(List<String> fileIds, List<String> dirIds, String targetDirId) {
        FileOpRequest request = new FileOpRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        request.setTargetDirId(targetDirId);
        this.batchCopyV1(request);
    }

    @Override
    public void batchCopyV1(FileOpRequest request) {
        try {
            this.fileInfoV1Operation.copyFileBatch(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void moveV1(String fileId, String targetDirId) {
        FileOpRequest request = new FileOpRequest();
        request.setFileId(fileId);
        request.setTargetDirId(targetDirId);
        this.moveV1(request);
    }

    @Override
    public void moveV1(FileOpRequest request) {
        try {
            this.fileInfoV1Operation.moveFile(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void moveDirV1(String dirId, String targetDirId) {
        FileOpRequest request = new FileOpRequest();
        request.setDirId(dirId);
        request.setTargetDirId(targetDirId);
        this.moveDirV1(request);
    }

    @Override
    public void moveDirV1(FileOpRequest request) {
        try {
            this.dirInfoV1Operation.moveDir(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void batchMoveV1(List<String> fileIds, List<String> dirIds, String targetDirId) {
        FileOpRequest request = new FileOpRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        request.setTargetDirId(targetDirId);
        this.batchMoveV1(request);
    }

    @Override
    public void batchMoveV1(FileOpRequest request) {
        try {
            this.fileInfoV1Operation.moveFileBatch(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String createDirV1(String dirName) {
        DirRequest request = new DirRequest();
        request.setDirInfo(new DirInfo(dirName));
        return this.createDirV1(request);
    }

    @Override
    public String createDirV1(String dirName, String parentId) {
        DirRequest request = new DirRequest();
        request.setDirInfo(new DirInfo(parentId, dirName));
        return this.createDirV1(request);
    }

    @Override
    public String createDirV1(DirRequest request) {
        try {
            return this.dirInfoV1Operation.createDir(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void renameDirV1(String dirId, String dirName) {
        DirRequest request = new DirRequest();
        request.setDirId(dirId);
        request.setDirName(dirName);
        this.renameDirV1(request);
    }

    @Override
    public void renameDirV1(DirRequest request) {
        try {
            this.dirInfoV1Operation.renameDir(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public DirInfo getDirInfoV1(String dirId) {
        DirRequest request = new DirRequest();
        request.setDirId(dirId);
        return this.getDirInfoV1(request);
    }

    @Override
    public DirInfo getDirInfoV1(DirRequest request) {
        try {
            return this.dirInfoV1Operation.getDirInfo(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public DirInfo getDirInfoByNameV1(String parentDirId, String dirName) {
        DirRequest request = new DirRequest();
        DirInfo dirInfo = new DirInfo();
        dirInfo.setParentId(parentDirId);
        dirInfo.setName(dirName);
        request.setDirInfo(dirInfo);
        try {
            return this.dirInfoV1Operation.getDirInfoByName(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public FolderInfo getDirContentV1(String dirId) {
        DirRequest request = new DirRequest();
        request.setDirId(dirId);
        return this.getDirContentV1(request);
    }

    @Override
    public FolderInfo getDirContentV1(DirRequest request) {
        try {
            return this.dirInfoV1Operation.getDirContent(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public void renameV1(String fileId, String fileName) {
        FileInfoRequest request = new FileInfoRequest();
        request.setFileId(fileId);
        request.setFileName(fileName);
        this.renameV1(request);
    }

    @Override
    public void renameV1(FileInfoRequest request) {
        try {
            this.fileInfoV1Operation.renameFile(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public FileInfo getFileInfoV1(String fileId) {
        FileInfoRequest request = new FileInfoRequest();
        request.setFileId(fileId);
        return this.getFileInfoV1(request);
    }

    @Override
    public FileInfo getFileInfoV1(FileInfoRequest request) {
        try {
            return this.fileInfoV1Operation.getFileInfo(request);
        }
        catch (Exception e) {
            throw new DMCException(e);
        }
    }

    @Override
    public String getToken(String username, String pwdhash, String tenantId) {
        return this.serviceClient.getAuthCache().getToken(username, pwdhash, tenantId);
    }
}

