/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.discard;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BatchOperationIds;
import com.digiwin.dmc.sdk.entity.ContentsResult;
import com.digiwin.dmc.sdk.entity.DirInfo;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.entity.Query.FileInfoQuery;
import com.digiwin.dmc.sdk.entity.Query.FullTextCondition;
import com.digiwin.dmc.sdk.entity.Query.QueryResult;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.discard.IDocumentStorageServiceDiscard;
import com.digiwin.dmc.sdk.service.download.GeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.IGeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.SegmentSegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.upload.GeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ISegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.SegmentDocumentUploader;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class DocumentStorageServiceDiscard
implements IDocumentStorageServiceDiscard {
    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String discardTenantId, String localPath, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(discardTenantId, null, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String discardTenantId, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(discardTenantId, null, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(discardTenantId, bucketName, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(discardTenantId, bucketName, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
        return new GeneralDocumentUploader(discardTenantId, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
        return new GeneralDocumentUploader(discardTenantId, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String discardTenantId, String localPath, FileInfo fileInfo) {
        return this.getUploaderByTenant(discardTenantId, null, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo) {
        return this.getUploaderByTenant(discardTenantId, bucketName, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null");
        }
        return new SegmentDocumentUploader(discardTenantId, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String discardTenantId, byte[] bytes, FileInfo fileInfo) {
        return this.getUploaderByTenant(discardTenantId, null, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.getUploaderByTenant(discardTenantId, bucketName, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null");
        }
        return new SegmentDocumentUploader(discardTenantId, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocumentByTenant(String discardTenantId, String fileId, String saveToPath) {
        return this.downloadDocumentByTenant(discardTenantId, null, fileId, saveToPath, null);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocumentByTenant(String discardTenantId, String bucketName, String fileId, String saveToPath) {
        return this.downloadDocumentByTenant(discardTenantId, bucketName, fileId, saveToPath, null);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocumentByTenant(String discardTenantId, String bucketName, String fileId, String saveToPath, String driveToken) {
        if (fileId == null || saveToPath == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            FileInfo fileInfo = this.getDocumentInfoByTenant(bucketName, fileId);
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new GeneralDocumentDownloader(discardTenantId, bucketName, fileId, saveToPath, driveToken, new TenantId[0]);
    }

    @Override
    public ISegmentDocumentDownloader getDownloaderByTenant(String discardTenantId, String fileId, String saveToPath) {
        return this.getDownloaderByTenant(discardTenantId, null, fileId, saveToPath, null);
    }

    @Override
    public ISegmentDocumentDownloader getDownloaderByTenant(String discardTenantId, String bucketName, String fileId, String saveToPath) {
        return this.getDownloaderByTenant(discardTenantId, bucketName, fileId, saveToPath, null);
    }

    @Override
    public ISegmentDocumentDownloader getDownloaderByTenant(String discardTenantId, String bucketName, String fileId, String saveToPath, String driveToken) {
        if (fileId == null || saveToPath == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        FileInfo fileInfo = this.getDocumentInfoByTenant(discardTenantId, bucketName, fileId);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new SegmentSegmentDocumentDownloader(discardTenantId, bucketName, fileId, saveToPath, (int)fileInfo.getSize(), driveToken, new TenantId[0]);
    }

    @Override
    public String deleteDocumentByTenant(String discardTenantId, String fileId) {
        return this.deleteDocumentByTenant(discardTenantId, null, fileId, null);
    }

    @Override
    public String deleteDocumentByTenant(String discardTenantId, String bucketName, String fileId) {
        return this.deleteDocumentByTenant(discardTenantId, bucketName, fileId, null);
    }

    @Override
    public String deleteDocumentByTenant(String discardTenantId, String bucketName, String fileId, String driveToken) {
        Map<String, String> headers;
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String deleteFileUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId;
        Map responseEntity = HttpRequestUtil.delete(deleteFileUrl, headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]), HashMap.class);
        if (null == responseEntity || !responseEntity.containsKey("recycleBinId")) {
            return null;
        }
        return responseEntity.get("recycleBinId").toString();
    }

    @Override
    public void deleteManyDocumentByTenant(String discardTenantId, BatchOperationIds operationIds) {
        this.deleteManyDocumentByTenant(discardTenantId, null, operationIds, null);
    }

    @Override
    public void deleteManyDocumentByTenant(String discardTenantId, String bucketName, BatchOperationIds operationIds) {
        this.deleteManyDocumentByTenant(discardTenantId, bucketName, operationIds, null);
    }

    @Override
    public void deleteManyDocumentByTenant(String discardTenantId, String bucketName, BatchOperationIds operationIds, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (operationIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570operationIds is null");
        }
        String deleteFileUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/delete/batch";
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            HttpRequestUtil.deleteJson(deleteFileUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, ArrayList.class);
        }
        catch (JsonProcessingException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public FileInfo getDocumentInfoByTenant(String discardTenantId, String fileId) {
        return this.getDocumentInfoByTenant(discardTenantId, null, fileId, null);
    }

    @Override
    public FileInfo getDocumentInfoByTenant(String discardTenantId, String bucketName, String fileId) {
        return this.getDocumentInfoByTenant(discardTenantId, bucketName, fileId, null);
    }

    @Override
    public FileInfo getDocumentInfoByTenant(String discardTenantId, String bucketName, String fileId, String driveToken) {
        Map<String, String> headers;
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String documentInfoUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/info";
        FileInfo fileInfo = HttpRequestUtil.get(documentInfoUrl, headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]), FileInfo.class);
        if (fileInfo == null) {
            return null;
        }
        return fileInfo;
    }

    @Override
    public void updateDocumentByTenant(String discardTenantId, String fileId, String fileName) {
        this.updateDocumentByTenant(discardTenantId, null, fileId, fileName, null);
    }

    @Override
    public void updateDocumentByTenant(String discardTenantId, String bucketName, String fileId, String fileName) {
        this.updateDocumentByTenant(discardTenantId, bucketName, fileId, fileName, null);
    }

    @Override
    public void updateDocumentByTenant(String discardTenantId, String bucketName, String fileId, String fileName, String driveToken) {
        try {
            if (fileId == null || "".equals(fileId) || fileName == null || "".equals(fileName)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String updateDocumentInfoUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/rename/" + fileName;
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            HttpRequestUtil.postJson(updateDocumentInfoUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveDocumentByTenant(String discardTenantId, String fileId, String targetDirectoryId) {
        this.moveDocumentByTenant(discardTenantId, null, fileId, targetDirectoryId, null);
    }

    @Override
    public void moveDocumentByTenant(String discardTenantId, String bucketName, String fileId, String targetDirectoryId) {
        this.moveDocumentByTenant(discardTenantId, bucketName, fileId, targetDirectoryId, null);
    }

    @Override
    public void moveDocumentByTenant(String discardTenantId, String bucketName, String fileId, String targetDirectoryId, String driveToken) {
        try {
            if (fileId == null || "".equals(fileId)) {
                throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
            }
            if (StringUtil.isEmpty(targetDirectoryId)) {
                targetDirectoryId = "00000000-0000-0000-0000-000000000000";
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/moveto/directory/" + targetDirectoryId;
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            HttpRequestUtil.postJson(moveDocumentUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveManyDocumentByTenant(String discardTenantId, BatchOperationIds operationIds, String targetDirectoryId) {
        this.moveManyDocumentByTenant(discardTenantId, null, operationIds, targetDirectoryId, null);
    }

    @Override
    public void moveManyDocumentByTenant(String discardTenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId) {
        this.moveManyDocumentByTenant(discardTenantId, bucketName, operationIds, targetDirectoryId, null);
    }

    @Override
    public void moveManyDocumentByTenant(String discardTenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken) {
        try {
            if (operationIds == null) {
                throw new IllegalArgumentException("\u53c2\u6570 operationIds is null");
            }
            if (StringUtil.isEmpty(targetDirectoryId)) {
                targetDirectoryId = "00000000-0000-0000-0000-000000000000";
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/move/batch/directory/" + targetDirectoryId;
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            HttpRequestUtil.postJson(moveDocumentUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDocumentByTenant(String discardTenantId, String fileId, String targetDirectoryId) {
        return this.copyDocumentByTenant(discardTenantId, null, fileId, targetDirectoryId, null);
    }

    @Override
    public String copyDocumentByTenant(String discardTenantId, String bucketName, String fileId, String targetDirectoryId) {
        return this.copyDocumentByTenant(discardTenantId, bucketName, fileId, targetDirectoryId, null);
    }

    @Override
    public String copyDocumentByTenant(String discardTenantId, String bucketName, String fileId, String targetDirectoryId, String driveToken) {
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
        }
        if (StringUtil.isEmpty(targetDirectoryId)) {
            targetDirectoryId = "00000000-0000-0000-0000-000000000000";
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/copyto/directory/" + targetDirectoryId;
        try {
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            Map responseEntity = HttpRequestUtil.postJson(copyDocumentUrl, "", headers, HashMap.class);
            if (null == responseEntity || !responseEntity.containsKey("id")) {
                return null;
            }
            return responseEntity.get("id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void copyManyDocumentByTenant(String discardTenantId, BatchOperationIds operationIds, String targetDirectoryId) {
        this.copyManyDocumentByTenant(discardTenantId, null, operationIds, targetDirectoryId, null);
    }

    @Override
    public void copyManyDocumentByTenant(String discardTenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId) {
        this.copyManyDocumentByTenant(discardTenantId, bucketName, operationIds, targetDirectoryId, null);
    }

    @Override
    public void copyManyDocumentByTenant(String discardTenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken) {
        if (operationIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
        }
        if (StringUtil.isEmpty(targetDirectoryId)) {
            targetDirectoryId = "00000000-0000-0000-0000-000000000000";
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/copy/batch/directory/" + targetDirectoryId;
        try {
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            HttpRequestUtil.postJson(copyDocumentUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, HashMap.class);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String createDirectoryByTenant(String discardTenantId, String directoryName, String parentDirectoryId) {
        return this.createDirectoryByTenant(discardTenantId, null, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectoryByTenant(String discardTenantId, String bucketName, String directoryName, String parentDirectoryId) {
        return this.createDirectoryByTenant(discardTenantId, bucketName, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectoryByTenant(String discardTenantId, String bucketName, String directoryName, String parentDirectoryId, String driveToken) {
        if (directoryName == null || "".equals(directoryName)) {
            throw new IllegalArgumentException("\u53c2\u6570 directoryName is null");
        }
        if (StringUtil.isEmpty(parentDirectoryId)) {
            parentDirectoryId = "00000000-0000-0000-0000-000000000000";
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String directoriesResourceUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys";
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("parentId", parentDirectoryId);
            parameters.put("name", directoryName);
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            Map responseEntity = HttpRequestUtil.postJson(directoriesResourceUrl, ObjectMapperUtil.writeValueAsString(parameters), headers, HashMap.class);
            if (null == responseEntity || !responseEntity.containsKey("dirId")) {
                return null;
            }
            return responseEntity.get("dirId").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public DirInfo getDirectoryInfoByTenant(String discardTenantId, String directoryId) {
        return this.getDirectoryInfoByTenant(discardTenantId, null, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfoByTenant(String discardTenantId, String bucketName, String directoryId) {
        return this.getDirectoryInfoByTenant(discardTenantId, bucketName, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfoByTenant(String discardTenantId, String bucketName, String directoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String documentInfoUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId;
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        return HttpRequestUtil.get(documentInfoUrl, headers, DirInfo.class);
    }

    @Override
    public String deleteDirectoryByTenant(String discardTenantId, String directoryId) {
        return this.deleteDirectoryByTenant(discardTenantId, null, directoryId, null);
    }

    @Override
    public String deleteDirectoryByTenant(String discardTenantId, String bucketName, String directoryId) {
        return this.deleteDirectoryByTenant(discardTenantId, bucketName, directoryId, null);
    }

    @Override
    public String deleteDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String driveToken) {
        Map<String, String> headers;
        String deleteDirectoryUrl;
        HashMap responseEntity;
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (null == (responseEntity = HttpRequestUtil.delete(deleteDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId, headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]), HashMap.class)) || !responseEntity.containsKey("recycleBinId")) {
            return null;
        }
        return responseEntity.get("recycleBinId").toString();
    }

    @Override
    public void updateDirectoryByTenant(String discardTenantId, String directoryId, String directoryName) {
        this.updateDirectoryByTenant(discardTenantId, null, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String directoryName) {
        this.updateDirectoryByTenant(discardTenantId, bucketName, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String directoryName, String driveToken) {
        try {
            if (directoryId == null || "".equals(directoryId) || directoryName == null || "".equals(directoryName)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String updateDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/rename/" + directoryName;
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            HttpRequestUtil.postJson(updateDirectoryUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveDirectoryByTenant(String discardTenantId, String directoryId, String targetDirectoryId) {
        this.moveDirectoryByTenant(discardTenantId, null, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String targetDirectoryId) {
        this.moveDirectoryByTenant(discardTenantId, bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        try {
            if (directoryId == null || "".equals(directoryId)) {
                throw new IllegalArgumentException("\u53c2\u6570directoryId is null");
            }
            if (targetDirectoryId == null || "".equals(targetDirectoryId)) {
                directoryId = "00000000-0000-0000-0000-000000000000";
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/moveto/" + targetDirectoryId;
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            HttpRequestUtil.postJson(moveDirectoryUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDirectoryByTenant(String discardTenantId, String directoryId, String targetDirectoryId) {
        return this.copyDirectoryByTenant(discardTenantId, null, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String targetDirectoryId) {
        return this.copyDirectoryByTenant(discardTenantId, bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectoryByTenant(String discardTenantId, String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u53c2\u6570directoryId is null");
        }
        if (targetDirectoryId == null || "".equals(targetDirectoryId)) {
            directoryId = "00000000-0000-0000-0000-000000000000";
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/copyto/" + targetDirectoryId;
        try {
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
            Map responseEntity = HttpRequestUtil.postJson(copyDirectoryUrl, "", headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("dirId")) {
                return null;
            }
            return responseEntity.get("dirId").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ContentsResult listContentsByTenant(String discardTenantId, String directoryId) {
        return this.listContentsByTenant(discardTenantId, null, directoryId, null);
    }

    @Override
    public ContentsResult listContentsByTenant(String discardTenantId, String bucketName, String directoryId) {
        return this.listContentsByTenant(discardTenantId, bucketName, directoryId, null);
    }

    @Override
    public ContentsResult listContentsByTenant(String discardTenantId, String bucketName, String directoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            directoryId = "00000000-0000-0000-0000-000000000000";
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String listContentsUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/list";
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        return HttpRequestUtil.get(listContentsUrl, headers, ContentsResult.class);
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQueryByTenant(String discardTenantId, String bucketName, FileInfoQuery query, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query";
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            String json = ObjectMapperUtil.writeValueAsString(query);
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, json, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQueryByTenant(String discardTenantId, String bucketName, FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQueryByTenant(discardTenantId, bucketName, query, null);
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQueryByTenant(String discardTenantId, FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQueryByTenant(discardTenantId, null, query, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldByTenant(String discardTenantId, String bucketName, String field, String value, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/values/" + value + "/";
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFieldByTenant(String discardTenantId, String bucketName, String field, String value) {
        return this.queryFileInfoByFieldByTenant(discardTenantId, bucketName, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldByTenant(String discardTenantId, String field, String value) {
        return this.queryFileInfoByFieldByTenant(discardTenantId, null, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPageByTenant(String discardTenantId, String bucketName, String field, String value, String pageNum, String pageSize, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/values/" + value + "/" + pageNum + "/" + pageSize;
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPageByTenant(String discardTenantId, String bucketName, String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPageByTenant(discardTenantId, bucketName, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPageByTenant(String discardTenantId, String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPageByTenant(discardTenantId, null, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPageByTenant(String discardTenantId, String bucketName, String field, String operator, String value, String pageNum, String pageSize, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/operators/" + operator + "/values/" + value + "/" + pageNum + "/" + pageSize;
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPageByTenant(String discardTenantId, String bucketName, String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPageByTenant(discardTenantId, bucketName, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPageByTenant(String discardTenantId, String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPageByTenant(discardTenantId, null, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorByTenant(String discardTenantId, String bucketName, String field, String operator, String value, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/operators/" + operator + "/values/" + value + "/";
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByOperatorByTenant(String discardTenantId, String bucketName, String field, String operator, String value) {
        return this.queryFileInfoByOperatorByTenant(discardTenantId, bucketName, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorByTenant(String discardTenantId, String field, String operator, String value) {
        return this.queryFileInfoByOperatorByTenant(discardTenantId, null, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByFullTextByTenant(String discardTenantId, String bucketName, FullTextCondition search, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getResourceUrl() + "/buckets/" + bucketName + "/query/fulltext";
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, new TenantId[0]);
        try {
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, ObjectMapperUtil.writeValueAsString(search), headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFullTextByTenant(String discardTenantId, String bucketName, FullTextCondition search) {
        return this.queryFileInfoByFullTextByTenant(discardTenantId, bucketName, search, null);
    }

    @Override
    public QueryResult queryFileInfoByFullTextByTenant(String discardTenantId, FullTextCondition search) {
        return this.queryFileInfoByFullTextByTenant(discardTenantId, null, search, null);
    }
}

