package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.model.Whitelist;

/**
 * 系统配置
 *
 * @author geyao
 * @since 5.4.0.0
 */
public interface SystemConfig {

    /**
     * 获取上传白名单
     *
     * @param sceneId 场景ID
     * @return 上传白名单
     * @throws Exception 异常
     */
    Whitelist getUploadWhitelist(String sceneId) throws Exception;

    /**
     * 添加上传白名单
     *
     * @param whitelist 上传白名单
     * @throws Exception 添加失败
     */
    void addUploadWhitelist(Whitelist whitelist) throws Exception;

    /**
     * 更新上传白名单
     *
     * @param whitelist 上传白名单
     * @throws Exception 更新失败
     */
    void updateUploadWhitelist(Whitelist whitelist) throws Exception;

    /**
     * 删除上传白名单
     *
     * @param sceneId 场景ID
     * @throws Exception 删除失败
     */
    void deleteUploadWhitelist(String sceneId) throws Exception;

    /**
     * 检查appId是否存在
     *
     * @param appId appId
     * @return 是否存在
     * @throws Exception 获取失败
     */
    boolean checkAppIdExist(String appId) throws Exception;

    /**
     * 添加appId
     *
     * @param appId appId
     * @throws Exception 添加失败
     */
    void addAppId(String appId) throws Exception;

    /**
     * 删除appId
     *
     * @param appId appId
     * @throws Exception 删除失败
     */
    void deleteAppId(String appId) throws Exception;

    /**
     * 更新bucket配置
     *
     * @param enableUploadWhitelist   是否开启上传白名单
     * @param checkOnlinePreviewToken 是否检查在线预览token
     * @throws Exception 更新失败
     */
    void updateBucketConfig(boolean enableUploadWhitelist, boolean checkOnlinePreviewToken) throws Exception;

    /**
     * 启用上传白名单
     *
     * @param enableUploadWhitelist 是否启用上传白名单
     * @throws Exception 启用失败
     */
    void enableUploadWhitelist(boolean enableUploadWhitelist) throws Exception;

    /**
     * 启用在线预览token
     *
     * @param enableOnlinePreviewToken 是否启用在线预览token
     * @throws Exception 启用失败
     */
    void enableOnlinePreviewToken(boolean enableOnlinePreviewToken) throws Exception;
}
