package com.digiwin.dap.middleware.dmc.common.comm;

import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.Method;

import java.net.URI;

public class HttpDeleteWithBody extends HttpUriRequestBase {

    public final static String METHOD_NAME = "DELETE";

    public HttpDeleteWithBody(final URI uri) {
        super(Method.DELETE.name(), uri);
    }

    /**
     * @throws IllegalArgumentException if the uri is invalid.
     */
    public HttpDeleteWithBody(final String uri) {
        super(Method.DELETE.name(), URI.create(uri));
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

}
