package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.dmc.DMCException;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;

public class EncryptionStrategyFactory {

    protected final byte[] key;

    public EncryptionStrategyFactory(byte[] key) {
        this.key = key;
    }

    public <T> T strategy(T t) {
        if (Objects.isNull(t)) {
            return null;
        }
        if (t instanceof File) {
            return (T) new FileEncryptionStrategy(key).encrypted((File) t);
        } else if (t instanceof byte[]) {
            return (T) new ByteArrayEncryptionStrategy(key).encrypted((byte[]) t);
        } else if (t instanceof InputStream) {
            return (T) new InputStreamEncryptionStrategy(key).encrypted((InputStream) t);
        }
        throw new DMCException("strategy not found!");
    }
}
