package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.utils.FileUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

public class FileEncryptionStrategy extends AbstractEncryptionStrategy<File> {

    protected static final Logger logger = LoggerFactory.getLogger(FileEncryptionStrategy.class);

    public FileEncryptionStrategy(byte[] aesKey) {
        super(aesKey);
    }

    @Override
    public File encrypted(File file) {
        super.check(file);
        byte[] ciphertext = AES.encryptIvCBC(FileUtils.readFileToByteArray(file), super.aesKey);
        if (ciphertext.length > 0) {
            return FileUtils.writeByteArrayToFile(ciphertext, file.getName());
        }
        throw new DMCException("文件加密为空!");
    }

}
