package com.digiwin.dap.middleware.dmc.common.utils;

import com.digiwin.dap.middleware.dmc.DMCException;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * 文件操作
 *
 * @author fobgochod
 * @date 2024/1/26 14:02
 */
public final class FileUtils {

    /**
     * 获取一个流，目录不存在创建所有父目录
     *
     * @param filePath 目录
     * @param fileName 文件名
     * @return OutputStream
     */
    public static OutputStream newOutputStream(String filePath, String fileName) throws IOException {
        Path dir = Paths.get(filePath);
        Files.createDirectories(dir);
        return Files.newOutputStream(dir.resolve(fileName));
    }

    /**
     * 创建一个空文件，目录不存在创建所有父目录
     *
     * @param filePath 目录
     * @param fileName 文件名
     * @return OutputStream
     */
    private static File createNewFile(String filePath, String fileName) throws IOException {
        Path dir = Paths.get(filePath);
        Files.createDirectories(dir);
        File file = dir.resolve(fileName).toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static byte[] readFileToByteArray(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] byteArray = new byte[(int) file.length()];
            fis.read(byteArray);
            fis.close();
            return byteArray;
        } catch (Exception e) {
            throw new DMCException("文件转字节数组异常", e);
        }
    }

    public static File writeByteArrayToFile(byte[] byteArray, String fileName) {
        try {
            File tempDir = new File(System.getProperty("java.io.tmpdir"), "temp");
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File tempFile = new File(tempDir, fileName);
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(byteArray);
            fos.close();
            return tempFile;
        } catch (Exception e) {
            throw new DMCException("写入文件异常", e);
        }
    }
}