package com.digiwin.dap.middleware.dmc.common.utils;

import com.digiwin.dap.middleware.dmc.common.comm.io.RepeatableFileInputStream;
import com.digiwin.dap.middleware.dmc.internal.DMCConstants;

import java.io.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;

public class IOUtils {

    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        try {
            return StreamUtils.copyToString(in, Charset.forName(charset));
        } finally {
            in.close();
        }
    }

    public static byte[] readStreamAsByteArray(InputStream in) throws IOException {
        return StreamUtils.copyToByteArray(in);
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            } catch (IOException e) {
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            } catch (IOException e) {
            }
        }
    }

    public static boolean checkFile(File file) {
        if (file == null) {
            return false;
        }

        boolean exists = false;
        boolean isFile = false;
        boolean canRead = false;
        try {
            exists = file.exists();
            isFile = file.isFile();
            canRead = file.canRead();
        } catch (SecurityException se) {
            // Swallow the exception and return false directly.
            return false;
        }

        return (exists && isFile && canRead);
    }

    public static InputStream newRepeatableInputStream(final InputStream original) throws IOException {
        InputStream repeatable = null;
        if (!original.markSupported()) {
            if (original instanceof FileInputStream) {
                repeatable = new RepeatableFileInputStream((FileInputStream) original);
            } else {
                repeatable = new BufferedInputStream(original, DMCConstants.DEFAULT_STREAM_BUFFER_SIZE);
            }
        } else {
            repeatable = original;
        }
        return repeatable;
    }

    public static Long getCRCValue(InputStream inputStream) {
        if (inputStream instanceof CheckedInputStream) {
            return ((CheckedInputStream) inputStream).getChecksum().getValue();
        }
        return null;
    }

    public static InputStream stringToInputStream(String text) throws IOException {
        InputStream inputStream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
//        int data;
//        while ((data = inputStream.read()) != -1) {
//            System.out.print((char) data);
//        }
        inputStream.close();
        return inputStream;

    }
}
