package com.digiwin.dap.middleware.dmc.internal.client;

import com.digiwin.dap.middleware.dmc.internal.DMCLogin;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class OSSConfig extends DMCLogin {

    /**
     * file upload
     */
    private static final String UPLOAD = "%s/api/dmc/v1/buckets/%s/files";
    private static final String UPLOAD_COVER = "%s/api/dmc/v1/buckets/%s/files/%s/cover";
    private static final String UPLOAD_SHARE = "%s/api/dmc/v1/buckets/%s/shareUploudFile";
    /**
     * file multipart upload
     */
    private static final String CLAIM_FILE_ID = "%s/api/dmc/v1/buckets/%s/files/segment";
    private static final String UPLOAD_PART = "%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s";
    private static final String UPLOAD_PART_COVER = "%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s/cover";
    /**
     * file download
     */
    private static final String DOWNLOAD = "%s/api/dmc/v1/buckets/%s/files/%s";
    private static final String DOWNLOAD_PART = "%s/api/dmc/v1/buckets/%s/files/%s/%s/%s";
    /**
     * file delete
     */
    private static final String DELETE = "%s/api/dmc/v1/buckets/%s/files/%s";
    private static final String DELETE_DIR = "%s/api/dmc/v1/buckets/%s/directorys/%s";
    private static final String DELETE_MULTI = "%s/api/dmc/v1/buckets/%s/files/delete/batch";
    private static final String DELETE_FORCE = "%s/api/dmc/v1/buckets/%s/files/%s/force";
    /**
     * file share
     */
    private static final String FILE_SHARE = "%s/api/dmc/v1/buckets/%s/ShareFiles";
    private static final String FILE_SHARE_DAY = "%s/api/dmc/v1/buckets/%s/ShareFiles/d/%s";
    private static final String FILE_SHARE_DEL = "%s/api/dmc/v1/%s/deleteShareFile/%s";
    /**
     * file info crud
     */
    private static final String FILE_GET = "%s/api/dmc/v1/buckets/%s/files/%s/info";
    private static final String FILE_RENAME = "%s/api/dmc/v1/buckets/%s/files/%s/rename/%s";
    private static final String FILE_COPY = "%s/api/dmc/v1/buckets/%s/files/%s/copyto/directory/%s";
    private static final String FILE_COPY_BATCH = "%s/api/dmc/v1/buckets/%s/files/copy/batch/directory/%s";
    private static final String FILE_MOVE = "%s/api/dmc/v1/buckets/%s/files/%s/moveto/directory/%s";
    private static final String FILE_MOVE_BATCH = "%s/api/dmc/v1/buckets/%s/files/move/batch/directory/%s";
    /**
     * dir info crud
     */
    private static final String DIR_ADD = "%s/api/dmc/v1/buckets/%s/directorys";
    private static final String DIR_GET = "%s/api/dmc/v1/buckets/%s/directorys/%s";
    private static final String DIR_GET_BY_NAME = "%s/api/dmc/v1/buckets/%s/directorys/%s/%s";
    private static final String DIR_RENAME = "%s/api/dmc/v1/buckets/%s/directorys/%s/rename/%s";
    private static final String DIR_CONTENT = "%s/api/dmc/v1/buckets/%s/directorys/%s/list";
    private static final String DIR_COPY = "%s/api/dmc/v1/buckets/%s/directorys/%s/copyto/%s";
    private static final String DIR_MOVE = "%s/api/dmc/v1/buckets/%s/directorys/%s/moveto/%s";


    private String getBucket(String assignBucket) {
        return assignBucket == null ? bucket : assignBucket;
    }

    public URI getUploadUrlV1(String bucket) {
        return URI.create(String.format(UPLOAD, uri, getBucket(bucket)));
    }

    public URI getUploadCoverUrlV1(String bucket, String fileId) {
        return URI.create(String.format(UPLOAD_COVER, uri, getBucket(bucket), fileId));
    }

    public URI getUploadShareUrlV1(String bucket) {
        return URI.create(String.format(UPLOAD_SHARE, uri, getBucket(bucket)));
    }

    public URI getClaimFileIdUrlV1(String bucket) {
        return URI.create(String.format(CLAIM_FILE_ID, uri, getBucket(bucket)));
    }

    public URI getUploadPartUrlV1(String bucket, String fileId, long from, long to, long total) {
        return URI.create(String.format(UPLOAD_PART, uri, getBucket(bucket), fileId, from, to, total));
    }

    public URI getUploadPartCoverUrlV1(String bucket, String fileId, long from, long to, long total) {
        return URI.create(String.format(UPLOAD_PART_COVER, uri, getBucket(bucket), fileId, from, to, total));
    }

    public URI getDownloadUrlV1(String bucket, String fileId) {
        return URI.create(String.format(DOWNLOAD, uri, getBucket(bucket), fileId));
    }

    public URI getDownloadPartUrlV1(String bucket, String fileId, long position, long length) {
        return URI.create(String.format(DOWNLOAD_PART, uri, getBucket(bucket), fileId, position, length));
    }

    public URI getDeleteUrlV1(String bucket, String fileId) {
        return URI.create(String.format(DELETE, uri, getBucket(bucket), fileId));
    }

    public URI getDeleteDirUrlV1(String bucket, String dirId) {
        return URI.create(String.format(DELETE_DIR, uri, getBucket(bucket), dirId));
    }

    public URI getDeleteMultiUrlV1(String bucket) {
        return URI.create(String.format(DELETE_MULTI, uri, getBucket(bucket)));
    }

    public URI getDeleteForceUrlV1(String bucket, String fileId) {
        return URI.create(String.format(DELETE_FORCE, uri, getBucket(bucket), fileId));
    }

    public URI getFileShareUrlV1(String bucket) {
        return URI.create(String.format(FILE_SHARE, uri, getBucket(bucket)));
    }

    public URI getFileShareDayUrlV1(String bucket, long expireDay) {
        return URI.create(String.format(FILE_SHARE_DAY, uri, getBucket(bucket), expireDay));
    }

    public URI getFileShareDelUrlV1(String bucket, String shareId) {
        return URI.create(String.format(FILE_SHARE_DEL, uri, getBucket(bucket), shareId));
    }

    public URI getFileInfoUrlV1(String bucket, String fileId) {
        return URI.create(String.format(FILE_GET, uri, getBucket(bucket), fileId));
    }

    public URI getRenameFileUrlV1(String bucket, String fileId, String fileName) {
        return URI.create(String.format(FILE_RENAME, uri, getBucket(bucket), fileId, URLEncoder.encode(fileName, StandardCharsets.UTF_8)));
    }

    public URI getFileCopyUrlV1(String bucket, String fileId, String targetDirId) {
        return URI.create(String.format(FILE_COPY, uri, getBucket(bucket), fileId, targetDirId));
    }

    public URI getFileCopyBatchUrlV1(String bucket, String targetDirId) {
        return URI.create(String.format(FILE_COPY_BATCH, uri, getBucket(bucket), targetDirId));
    }

    public URI getFileMoveUrlV1(String bucket, String fileId, String targetDirId) {
        return URI.create(String.format(FILE_MOVE, uri, getBucket(bucket), fileId, targetDirId));
    }

    public URI getFileMoveBatchUrlV1(String bucket, String targetDirId) {
        return URI.create(String.format(FILE_MOVE_BATCH, uri, getBucket(bucket), targetDirId));
    }

    public URI getCreateDirUrlV1(String bucket) {
        return URI.create(String.format(DIR_ADD, uri, getBucket(bucket)));
    }

    public URI getDirInfoUrlV1(String bucket, String dirId) {
        return URI.create(String.format(DIR_GET, uri, getBucket(bucket), dirId));
    }

    public URI getDirInfoGetByNameUrlV1(String parentDirId, String dirName) {
        return URI.create(String.format(DIR_GET_BY_NAME, uri, bucket, parentDirId, URLEncoder.encode(dirName, StandardCharsets.UTF_8)));
    }

    public URI getRenameDirUrlV1(String bucket, String dirId, String dirName) {
        return URI.create(String.format(DIR_RENAME, uri, getBucket(bucket), dirId, URLEncoder.encode(dirName, StandardCharsets.UTF_8)));
    }

    public URI getDirContentUrlV1(String bucket, String dirId) {
        return URI.create(String.format(DIR_CONTENT, uri, getBucket(bucket), dirId));
    }

    public URI getDirCopyUrlV1(String bucket, String dirId, String targetDirId) {
        return URI.create(String.format(DIR_COPY, uri, getBucket(bucket), dirId, targetDirId));
    }

    public URI getDirMoveUrlV1(String bucket, String dirId, String targetDirId) {
        return URI.create(String.format(DIR_MOVE, uri, getBucket(bucket), dirId, targetDirId));
    }
}
