package com.digiwin.dap.middleware.dmc.internal.client.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

import java.util.List;

public class ShareV1Request extends GenericRequest {

    private List<String> fileIds;
    private long expireDay;
    private String shareId;

    public List<String> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public long getExpireDay() {
        return expireDay;
    }

    public void setExpireDay(long expireDay) {
        this.expireDay = expireDay;
    }

    public String getShareId() {
        return shareId;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    @Override
    public HttpEntity build() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(fileIds))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
