package com.digiwin.dap.middleware.dmc.internal.client.model;

import com.digiwin.dap.middleware.dmc.internal.DMCHeaders;
import com.digiwin.dap.middleware.dmc.model.UploadRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.HttpEntity;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class UploadV1Request extends UploadRequest {

    @Override
    public HttpEntity build() {
        EntityBuilder builder = EntityBuilder.create();
        if (input != null) {
            builder.setStream(input);
        }
        if (fileInfo != null) {
            try {
                String fileInfoJson = URLEncoder.encode(JsonUtils.writeValue(fileInfo), StandardCharsets.UTF_8.name());
                this.getHeaders().put(DMCHeaders.HTTP_HEADER_API_ARG_KEY, fileInfoJson);
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.build();
    }
}
