package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.DownloadPartRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;

/**
 * 下载
 *
 * @author fobgochod
 * @date 2021/4/29
 */
public class DownloadV1Operation extends DMCOperation {

    public DownloadV1Operation(ServiceClient client) {
        super(client);
    }

    /**
     * 下载<br>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/files/{fileId}
     */
    public byte[] download(DownloadRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDownloadUrlV1(original.getBucket(), original.getFileId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.downloadResponseParser);
    }

    /**
     * 分段下载<br>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/{position}/{length}
     */
    public byte[] downloadPart(DownloadPartRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDownloadPartUrlV1(original.getBucket(), original.getFileId(), original.getPosition(), original.getLength()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.downloadResponseParser);
    }
}


