package com.digiwin.dap.middleware.dmc.internal.model;

import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.HttpEntity;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A generic request that contains some basic request options, such as bucket
 * name, object key, custom headers, progress listener and so on.
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class GenericRequest extends BucketRequest {

    private HttpEntity entity;
    private Map<String, String> headers = new LinkedHashMap<>();
    private long contentLength;

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public long getContentLength() {
        return contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public synchronized HttpEntity getEntity() {
        if (entity == null) entity = build();
        return entity;
    }

    public HttpEntity build() {
        return EntityBuilder.create().build();
    }
}
