package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 批量操作 下载、删除、分享
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class BatchRequest extends GenericRequest {

    /**
     * 文件信息ID
     */
    private String fileId;
    /**
     * 目录ID
     */
    private String dirId;
    /**
     * 回收站ID
     */
    private String recycleId;
    /**
     * 文件ID集合
     */
    private List<String> fileIds;
    /**
     * 目录ID集合
     */
    private List<String> dirIds;
    /**
     * 分享ID集合
     */
    private List<String> shareIds;
    /**
     * 回收站ID集合
     */
    private List<String> recycleIds;

    public BatchRequest() {
        this.fileIds = new ArrayList<>();
        this.dirIds = new ArrayList<>();
        this.shareIds = new ArrayList<>();
        this.recycleIds = new ArrayList<>();
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getDirId() {
        return dirId;
    }

    public void setDirId(String dirId) {
        this.dirId = dirId;
    }

    public String getRecycleId() {
        return recycleId;
    }

    public void setRecycleId(String recycleId) {
        this.recycleId = recycleId;
    }

    public List<String> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public List<String> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<String> dirIds) {
        this.dirIds = dirIds;
    }

    public List<String> getShareIds() {
        return shareIds;
    }

    public void setShareIds(List<String> shareIds) {
        this.shareIds = shareIds;
    }

    public List<String> getRecycleIds() {
        return recycleIds;
    }

    public void setRecycleIds(List<String> recycleIds) {
        this.recycleIds = recycleIds;
    }

    @Override
    public HttpEntity build() {
        Map<String, Object> map = new HashMap<>(6);
        map.put("fileId", fileId);
        map.put("fileIds", fileIds);
        map.put("dirId", dirId);
        map.put("dirIds", dirIds);
        map.put("shareIds", shareIds);
        map.put("recycleIds", recycleIds);
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(map))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
