package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * 下载参数
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class DownloadRequest extends GenericRequest {


    private String fileId;
    private OutputStream output;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public OutputStream getOutput() {
        return output;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    @Override
    public HttpEntity build() {
        Map<String, Object> map = new HashMap<>();
        map.put("fileId", fileId);
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(map))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
