package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

/**
 * 文件信息
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class FileInfoRequest extends GenericRequest {

    private String fileId;
    private String fileName;
    private FileInfo fileInfo;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    @Override
    public HttpEntity build() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(fileInfo))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
