package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.HttpEntity;

/**
 * 分段上传参数
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class PartUploader extends GenericRequest {

    private String fileId;
    private byte[] parts;
    private long from;
    private long to;
    private long total;
    private int partCount;
    private int partNum;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public byte[] getParts() {
        return parts;
    }

    public void setParts(byte[] parts) {
        this.parts = parts;
    }

    public long getFrom() {
        return from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPartCount() {
        return partCount;
    }

    public void setPartCount(int partCount) {
        this.partCount = partCount;
    }

    public int getPartNum() {
        return partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    public HttpEntity build() {
        return builder().build();
    }

    protected EntityBuilder builder() {
        EntityBuilder builder = EntityBuilder.create();
        if (parts != null) {
            builder.setBinary(parts);
        }
        return builder;
    }
}
