package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分享文件
 *
 * @author fobgochod
 * @since 5.3.2.0
 */
public class ShareRequest extends GenericRequest {

    /**
     * 文件信息ID
     */
    private String fileId;
    /**
     * 过期时间
     */
    private LocalDateTime expireDate;
    /**
     * 可访问次数
     */
    private Integer allowCount;
    /**
     * 访问次数归零-是否删除文件
     */
    private Boolean deleteFile;

    /**
     * 分享限制
     */
    private SharePermission sharePermission;

    /**
     * 分享目标
     */
    private List<String> usersTarget;

    /**
     * 分享密码
     */
    private String pwd;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public LocalDateTime getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }

    public Integer getAllowCount() {
        return allowCount;
    }

    public void setAllowCount(Integer allowCount) {
        this.allowCount = allowCount;
    }

    public Boolean getDeleteFile() {
        return deleteFile;
    }

    public void setDeleteFile(Boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public SharePermission getSharePermission() {
        return sharePermission;
    }

    public void setSharePermission(SharePermission sharePermission) {
        this.sharePermission = sharePermission;
    }

    public List<String> getUsersTarget() {
        return usersTarget;
    }

    public void setUsersTarget(List<String> usersTarget) {
        this.usersTarget = usersTarget;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Override
    public HttpEntity build() {
        Map<String, Object> map = new HashMap<>(6);
        map.put("fileId", fileId);
        map.put("expireDate", expireDate);
        map.put("allowCount", allowCount);
        map.put("deleteFile", deleteFile);
        map.put("sharePermission", sharePermission);
        map.put("usersTarget", usersTarget);
        map.put("pwd", pwd);
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(map))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
