package com.digiwin.dmc.sdk.entity;

import com.digiwin.dap.middleware.dmc.model.FolderInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * ContentsResult
 *
 * @author chenzwd
 * @date 2018-08-13 16:24
 */
public class ContentsResult {

    private List<FileInfo> fileInfos = new ArrayList<>();
    private List<DirInfo> dirInfos = new ArrayList<>();

    public ContentsResult() {
    }

    public ContentsResult(FolderInfo folderInfo) {
        this.fileInfos = folderInfo.getFileInfos().stream().map(FileInfo::new).collect(Collectors.toList());
        this.dirInfos = folderInfo.getDirInfos().stream().map(DirInfo::new).collect(Collectors.toList());
    }

    public List<FileInfo> getFileInfos() {
        return fileInfos;
    }

    public void setFileInfos(List<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
    }

    public List<DirInfo> getDirInfos() {
        return dirInfos;
    }

    public void setDirInfos(List<DirInfo> dirInfos) {
        this.dirInfos = dirInfos;
    }
}
