package com.digiwin.dmc.sdk.entity;

import com.digiwin.dmc.sdk.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * DriveAuthItem
 *
 * @author chenxsa
 * @date 2018-6-6 14:25
 */
public class DriveAuthItem implements Serializable {

    /**
     * 区块名称
     */
    @JsonProperty("Bucket")
    private String bucket;
    /**
     * 请求动作(Read, Write, Auth)
     */
    @JsonProperty("ActionName")
    private DriveAuthRequestAction actionName;
    /**
     * 请求对象类型(Directory, File)
     */
    @JsonProperty("ObjectType")
    private DriveAuthRequestObjectType objectType;
    /**
     * 请求对象Id
     */
    @JsonProperty("ObjectId")
    private String objectId;

    public DriveAuthItem() {

    }

    public DriveAuthItem(String bucket, DriveAuthRequestAction actionName, DriveAuthRequestObjectType objectType, String objectId) {

        this.bucket = bucket;
        this.actionName = actionName;
        this.objectType = objectType;
        this.objectId = objectId;
    }

    public String getBucket() {
        return bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public DriveAuthRequestAction getActionName() {
        return actionName;
    }

    public void setActionName(DriveAuthRequestAction actionName) {
        this.actionName = actionName;
    }

    public DriveAuthRequestObjectType getObjectType() {
        return objectType;
    }

    public void setObjectType(DriveAuthRequestObjectType objectType) {
        this.objectType = objectType;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DriveAuthItem) {
            DriveAuthItem item = (DriveAuthItem) obj;
            if (bucket == null || item.bucket == null) {
                return false;
            }
            if (actionName == null || item.actionName == null) {
                return false;
            }

            return bucket.equals(item.bucket)
                    && objectType == item.objectType
                    && actionName.equals(item.actionName)
                    && StringUtil.equals(objectId, item.objectId);

        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        if (bucket != null) {
            hash = bucket.hashCode();
        }
        if (objectType != null) {
            hash = hash ^ objectType.hashCode();
        }
        if (actionName != null) {
            hash = hash ^ actionName.hashCode();
        }
        if (objectId != null) {
            hash = hash ^ objectId.hashCode();
        }
        return hash;
    }
}
