package com.digiwin.dmc.sdk.service;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dmc.sdk.entity.BucketInfo;

import java.util.List;

/**
 * 存储区管理
 */
public interface IBucketManagerService {

    /**
     * 创建存储区
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets
     *
     * @param bucketInfo bucket信息
     * @return id
     */
    String createBucket(BucketInfo bucketInfo);

    @Deprecated
    String createBucketByTenant(String discardTenantId, BucketInfo bucketInfo);

    /**
     * 获取存储区
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets
     *
     * @return Bucket信息
     */
    List<BucketInfo> getBuckets();

    /**
     * 判断Bucket是否存在
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/isExist
     *
     * @return true/false
     */
    String isExistBucket(String bucketName);

    @Deprecated
    String isExistBucketByTenant(String discardTenantId, String bucketName);
}
