package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;

public interface IFileService {

    /**
     * 下载文件
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/files/{fileId}
     *
     * @param fileId   文件ID
     * @param tenantId 租户ID
     * @return 文件字节流
     */
    byte[] download(String fileId, TenantId... tenantId);

    byte[] download(String bucketName, String fileId, TenantId... tenantId);

    byte[] download(String discardTenantId, String bucketName, String fileId, TenantId... tenantId);

    byte[] download(String discardTenantId, String bucketName, String fileId, String driveToken, TenantId... tenantId);
}
