package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadV1Request;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

/**
 * 覆盖上传
 * /api/dmc/v1/buckets/{bucket}/files/{fileId}/cover
 *
 * @date 2022/6/7 14:08
 */
public class CoverGeneralDocumentUploader implements ICoverGeneralDocumentUploader {

    private String bucketName;
    private String fileId;
    private String driveToken;
    private TenantId[] tenantId;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private CoverGeneralDocumentUploader(String bucketName, String fileId, String driveToken, TenantId... tenantId) {
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public CoverGeneralDocumentUploader(String bucketName, String localPath, String fileId, String driveToken, TenantId... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath));
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public CoverGeneralDocumentUploader(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    /**
     * 上传Stream中的文件内容，同步模式
     *
     * @return
     */
    @Override
    public ICoverGeneralDocumentUploader upload() {
        try {
            bucketName = ArgumentUtils.getBucketName(bucketName);
            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Runnable runnable = () -> {
                try {
                    IamUserTokenHolder.setContext(iamUserToken);
                    UploadV1Request request = new UploadV1Request();
                    request.setBucket(bucketName);
                    request.setHeaders(headers);
                    request.setInput(inputStream);
                    request.setFileId(fileId);
                    ServerSetting.internal().uploadCoverV1(request);
                    if (completeCallback != null) {
                        eventArgs.setFileId(fileId);
                        eventArgs.setPercentage(1);
                        completeCallback.callback(eventArgs);
                    }
                } finally {
                    IamUserTokenHolder.clearContext();
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 设置完成
     */
    @Override
    public ICoverGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
