package com.digiwin.dmc.sdk.util;

import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;

import java.io.IOException;

/**
 * 全局支持跨域访问api
 *
 * @author chenxsa
 */
public class ObjectMapperUtil {

    /**
     * 序列化实体
     *
     * @param data 对象
     * @return json
     */
    public static String writeValueAsString(Object data) throws JsonProcessingException {
        return JsonUtils.createDmcObjectMapper().writeValueAsString(data);
    }

    /**
     * 反序列化对象
     *
     * @param json      json
     * @param valueType 实体类型
     * @param <T>       泛型
     * @return 对象
     */
    public static <T> T readValue(String json, Class<T> valueType) throws IOException {
        return JsonUtils.createDmcObjectMapper().readValue(json, valueType);
    }
}
