/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.IndexType;
import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.RoleEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.UserType;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.BucketUser;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.BucketUserRepository;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskIdEnum;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskManagerService;
import com.digiwin.dap.middleware.dmc.util.DocumentUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TemplateFilesJson;
import com.mongodb.client.MongoCollection;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class DmcStartedListener
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(DmcStartedListener.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    private BucketUserRepository bucketUserRepository;
    @Autowired
    private FileUploadService fileUploadService;
    @Value(value="classpath:/templateFiles.json")
    private Resource templateFiles;
    @Value(value="classpath:/consoleTemplateFiles.json")
    private Resource consoleTemplateFiles;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private DirectoryCrudService directoryCrudService;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.createDateIndex();
            this.initSysDefault();
            this.initDefaultUser();
            this.initScheduled();
            this.initDictionary();
            this.initBucketCreator("digiwindev", "\u5f00\u53d1\u8005\u95e8\u6237", "digiwindev", "digiwindev1qaz@WSX", Collections.emptyList());
            this.initSecretKey();
        }
    }

    private void initSysDefault() {
        this.initUser("admin", "\u7cfb\u7edf\u7ba1\u7406\u5458", "dmcadmin", RoleEnum.SysAdmin);
        this.initBucketCreator("test", "\u7cfb\u7edf\u6d4b\u8bd5\u5458", "test", "test", Collections.singletonList("admin"));
        this.initUser("operationAdmin", "\u5de5\u7a0b\u7ba1\u7406\u5458", "Digiwin2024", RoleEnum.SysAdmin);
        this.initBucketUser("operationAdmin", "test", UserType.IAM);
    }

    private void initDefaultUser() {
        if (0 == this.envProperties.getCloud()) {
            this.initBucketCreator("digiwincloud", "\u4e91\u5e02\u573a\u6570\u636e\u5e93", "digiwincloud", "digiwincloud", Collections.singletonList("admin"));
        } else if (1 == this.envProperties.getCloud()) {
            this.initBucketCreator("digiwincloud", "\u4e91\u5e02\u573a\u6570\u636e\u5e93", "landingdigiwincloud", "landingdigiwincloud", Collections.singletonList("admin"));
            this.initDefaultTemplate(this.consoleTemplateFiles, "console");
        } else if (2 == this.envProperties.getCloud() || 3 == this.envProperties.getCloud() || 4 == this.envProperties.getCloud()) {
            this.initBucketCreator("digiwincloud", "\u4e91\u5e02\u573a\u6570\u636e\u5e93", "landingdigiwincloud", "landingdigiwincloud", Collections.singletonList("admin"));
            this.initDefaultTemplate(this.templateFiles, "market");
        }
        logger.info(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, "default user has init successfully!"}));
    }

    private void initBucketCreator(String bucketName, String description, String name, String password, List<String> admins) {
        this.initUser(name, name, password, RoleEnum.BucketCreator);
        this.initBucket(bucketName, description, name, admins);
        admins.forEach(admin -> this.initBucketUser(admin, bucketName, UserType.ADMIN));
    }

    private void initUser(String name, String displayName, String password, RoleEnum role) {
        if (!this.userRepository.existsByName(name)) {
            User user = new User();
            user.setPwdHash(DigestUtils.sha256((String)password, (int)2));
            user.setName(name);
            user.setDisplayName(displayName);
            user.setBuiltinRole(role.name());
            this.userRepository.insert((ObIdEntity)user);
        }
    }

    private void initBucket(String bucketName, String description, String owner, List<String> admins) {
        if (!this.bucketRepository.existsByNameAndOwner(bucketName, owner)) {
            Bucket bucket = new Bucket();
            bucket.setName(bucketName);
            bucket.setOwner(owner);
            bucket.setAdmins(admins);
            bucket.setDescription(description);
            bucket.flushKey();
            this.bucketRepository.insert((ObIdEntity)bucket);
        }
    }

    private void initBucketUser(String userName, String bucketName, UserType userType) {
        if (!this.bucketUserRepository.existsByUserIdAndBucketAndType(userName, bucketName, userType.ordinal())) {
            BucketUser bucket = new BucketUser();
            bucket.setUserId(userName);
            bucket.setBucket(bucketName);
            bucket.setType(Integer.valueOf(userType.ordinal()));
            this.bucketUserRepository.insert((ObIdEntity)bucket);
        }
    }

    private void createDateIndex() {
        MongoCollection tasksLog = this.mongoTemplate.getCollection("tasks_log");
        DocumentUtil.createIndex((MongoCollection)tasksLog, (String)"createDate", (Object)IndexType.DESC);
        MongoCollection statsDiskLog = this.mongoTemplate.getCollection("stats_disk_log");
        DocumentUtil.createIndex((MongoCollection)statsDiskLog, (String)"createDate", (Object)IndexType.DESC);
        MongoCollection statsDiskDetailLog = this.mongoTemplate.getCollection("stats_disk_detail");
        DocumentUtil.createIndex((MongoCollection)statsDiskDetailLog, (String)"createDate", (Object)IndexType.DESC);
        MongoCollection statsVisitLog = this.mongoTemplate.getCollection("stats_visit_log");
        DocumentUtil.createIndex((MongoCollection)statsVisitLog, (String)"createDate", (Object)IndexType.DESC);
        MongoCollection buckets = this.mongoTemplate.getCollection("buckets");
        DocumentUtil.createUniqueIndex((MongoCollection)buckets, (String)"Name", (Object)IndexType.ASC);
        MongoCollection users = this.mongoTemplate.getCollection("users");
        DocumentUtil.createUniqueIndex((MongoCollection)users, (String)"Name", (Object)IndexType.ASC);
    }

    private void initDefaultTemplate(Resource resource, String directory) {
        try {
            List jsonList = TemplateFilesJson.getJson((Resource)resource);
            jsonList.forEach(o -> {
                Map json = (Map)o;
                try {
                    String filePath = String.format("/templates/email/%s/%s", directory, json.get("fileName"));
                    logger.info("\u521d\u59cb\u5316\u6570\u636e\uff0c\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6{}", (Object)filePath);
                    InputStream stream = this.getClass().getResourceAsStream(filePath);
                    FileInfo fileInfo = new FileInfo();
                    fileInfo.setId(IdUtil.uuid((String)((String)json.get("id"))));
                    fileInfo.setFileName((String)json.get("fileName"));
                    fileInfo.setDisplayName((String)json.get("displayName"));
                    fileInfo.setDescription((String)json.get("description"));
                    if (!this.fileInfoCrudService.existsById("digiwincloud", fileInfo.getId())) {
                        this.fileUploadService.uploadFromStream("digiwincloud", fileInfo, stream);
                    }
                }
                catch (Exception ex) {
                    logger.error(String.format("\u521d\u59cb\u5316\u66f4\u65b0\u90ae\u4ef6\u6a21\u677f%s\u51fa\u9519", json.get("fileName")), (Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            logger.error("\u521d\u59cb\u5316\u90ae\u4ef6\u6a21\u677f\u51fa\u9519", (Throwable)ex);
        }
    }

    private void initScheduled() {
        this.taskRepository.dropCollection();
        for (TaskIdEnum taskId : TaskIdEnum.values()) {
            Task task = new Task();
            task.setType(taskId.getType().desc());
            task.setCode(taskId.name());
            task.setTitle(taskId.getTitle());
            task.setPeriod(taskId.getPeriod());
            task.setOperation(taskId.getOperation().name());
            task.setDisable(taskId.getDisable());
            task.setCron(taskId.getCron());
            task.setClassName(taskId.getClassName().getName());
            this.taskRepository.insert((ObIdEntity)task);
        }
        this.taskManagerService.refresh();
        logger.info(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, "Task schedule has init successfully!"}));
    }

    private void initDictionary() {
        ToAnalysis.parse((String)"DigiwinSoft");
        logger.info(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, "Dictionary has init successfully!"}));
    }

    public void initSecretKey() {
        List buckets = this.bucketRepository.findAll();
        for (Bucket bucket : buckets) {
            if (!StrUtils.isEmpty((String)bucket.getPublicKey())) continue;
            bucket.flushKey();
            this.bucketRepository.replace((ObIdEntity)bucket);
        }
    }

    private void initTestData() {
        for (int i = 0; i < 1000; ++i) {
            DirInfo dirInfo = new DirInfo();
            dirInfo.setName("\u76ee\u5f55" + i);
            dirInfo.setParentId(BaseField.EMPTY_UUID);
            dirInfo.setBucket("test");
            this.directoryCrudService.insert((UuIdEntity)dirInfo);
            for (int j = 0; j < 1000; ++j) {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName("\u6587\u4ef6" + i + ".txt");
                fileInfo.setDirectoryId(dirInfo.getId().toString());
                fileInfo.setBucket("test");
                this.fileInfoCrudService.insert((UuIdEntity)fileInfo);
            }
        }
    }
}

