/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.commons.crypto.constant.KeySizeEnum;
import com.digiwin.dap.middleware.commons.crypto.constant.TransformationEnum;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.annotation.LoginMark;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.service.login.LoginContext;
import com.digiwin.dap.middleware.dmc.support.auth.domain.GetAesKeyRequest;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginRequest;
import com.digiwin.dap.middleware.dmc.support.auth.domain.LoginUser;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class LoginController {
    @Autowired
    private LoginContext loginContext;

    @LoginMark
    @PostMapping(value={"/auth/login"})
    public ResponseEntity<?> login(@Valid @RequestBody LoginUser body) {
        String userToken = this.loginContext.login(body);
        if (ObjectUtils.isEmpty((Object)userToken)) {
            throw new UnauthorizedException((ErrorHandler)I18nError.LOGIN_FAIL);
        }
        return ResponseEntity.ok(Collections.singletonMap("userToken", userToken));
    }

    @PostMapping(value={"/auth/token/analyze"})
    public StdData<?> login(@RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        return StdData.ok((Object)userInfo);
    }

    @LoginMark(value=LogType.LOGIN_REFRESH)
    @PostMapping(value={"/auth/token/refresh"})
    public ResponseEntity<?> login(@RequestBody LoginUser body, HttpServletRequest request) {
        String userToken = request.getHeader(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY);
        if (userToken == null) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_REFRESH_KEK_NONE, new Object[]{GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY});
        }
        String tenantId = TenantUtil.getTenant((String)body.getTenantId());
        String token = this.loginContext.refresh(userToken, tenantId);
        if (ObjectUtils.isEmpty((Object)token)) {
            throw new UnauthorizedException((ErrorHandler)I18nError.LOGIN_FAIL);
        }
        return ResponseEntity.ok(Collections.singletonMap("userToken", token));
    }

    @PostMapping(value={"/auth/aes/key"})
    public StdData<?> getAesKey(@Valid @RequestBody GetAesKeyRequest request) {
        byte[] clientPublicKeyByte = RSA.decrypt((byte[])Base64.decode((String)request.getClientPublicKeyCiphertext()), (byte[])Base64.decode((String)KeyConstant.BASE64_PRIVATE_KEY), (String)TransformationEnum.RSA_ECB_PKCS1Padding.getValue());
        byte[] aesKey = AES.generateKey((int)KeySizeEnum.AES_256.getValue());
        String aesKeyCipherText = Base64.encode((byte[])RSA.encrypt((byte[])aesKey, (byte[])clientPublicKeyByte, (String)TransformationEnum.RSA_ECB_PKCS1Padding.getValue()));
        return StdData.ok((Object)aesKeyCipherText);
    }

    @LoginMark(value=LogType.LOGIN_SECURITY)
    @PostMapping(value={"/auth/security/login"})
    public StdData<?> securityLogin(@Valid @RequestBody LoginRequest request) {
        byte[] aesKey = RSA.decrypt((byte[])Base64.decode((String)request.getAesKeyCiphertext()), (byte[])Base64.decode((String)KeyConstant.BASE64_PRIVATE_KEY), (String)TransformationEnum.RSA_ECB_PKCS1Padding.getValue());
        String password = new String(AES.decryptIvCBC((byte[])Base64.decode((String)request.getPasswordHash()), (byte[])aesKey));
        String username = new String(AES.decryptIvCBC((byte[])Base64.decode((String)request.getUsernameHash()), (byte[])aesKey));
        LoginUser loginUser = new LoginUser();
        loginUser.setUsername(username);
        loginUser.setPwdhash(password);
        loginUser.setLoginType(request.getLoginType());
        loginUser.setTenantId(request.getTenantId());
        String userToken = this.loginContext.login(loginUser);
        if (ObjectUtils.isEmpty((Object)userToken)) {
            throw new UnauthorizedException((ErrorHandler)I18nError.LOGIN_FAIL);
        }
        return StdData.ok((Object)userToken);
    }
}

