/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api;

import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.request.ResourceGoodsRequest;
import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.request.ResourceGoodsUseRecordRequest;
import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.vo.ResourceGoodsPurchaseRecordVO;
import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.vo.ResourceGoodsUseRecordVO;
import com.digiwin.dap.middleware.dmc.domain.resource.goods.use.record.vo.ResourceGoodsVO;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoods;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsPurchaseRecord;
import com.digiwin.dap.middleware.dmc.entity.ResourceGoodsUseRecord;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsPurchaseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsRepository;
import com.digiwin.dap.middleware.dmc.repository.ResourceGoodsUseRecordRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskRepository;
import com.digiwin.dap.middleware.dmc.service.resource.goods.ResourceGoodsBizService;
import com.digiwin.dap.middleware.dmc.support.remote.CacService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/resource/goods"})
public class ResourceGoodsController {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGoodsController.class);
    @Autowired
    private ResourceGoodsRepository resourceGoodsRepository;
    @Autowired
    private ResourceGoodsPurchaseRecordRepository resourceGoodsPurchaseRecordRepository;
    @Autowired
    private ResourceGoodsUseRecordRepository resourceGoodsUseRecordRepository;
    @Autowired
    private ResourceGoodsBizService resourceGoodsBizService;
    @Autowired
    private CacService cacService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private StatsDiskRepository statsDiskRepository;

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody ResourceGoodsRequest request) {
        List resourceGoodsList = this.resourceGoodsRepository.findByCondition(request.getCode(), request.getProductCode());
        return StdData.ok(resourceGoodsList.stream().map(arg_0 -> this.buildResourceGoodsVO(arg_0)).collect(Collectors.toList()));
    }

    @PostMapping(value={"/purchase/record/search"})
    public StdData<?> resourceGoodsPurchaseRecordSearch() {
        List resourceGoodsPurchaseRecordList = this.resourceGoodsPurchaseRecordRepository.findAll();
        return StdData.ok(resourceGoodsPurchaseRecordList.stream().map(arg_0 -> this.buildResourceGoodsPurchaseRecordVO(arg_0)).collect(Collectors.toList()));
    }

    @PostMapping(value={"/use/record/search"})
    public StdData<?> resourceGoodsUseRecordSearch(@RequestBody ResourceGoodsUseRecordRequest request) {
        List resourceGoodsUseRecordList = this.resourceGoodsUseRecordRepository.findByStartTimeAndEndTime(request.getStartTime(), request.getEndTime());
        return StdData.ok(resourceGoodsUseRecordList.stream().map(arg_0 -> this.buildResourceGoodsUseRecordVO(arg_0)).collect(Collectors.toList()));
    }

    @GetMapping(value={"purchase/record/save"})
    public StdData<?> resourceGoodsPurchaseRecordSave(@RequestParam(value="purchaseId") String purchaseId) {
        this.resourceGoodsBizService.saveResourceGoodsPurchaseRecord(this.cacService.findPurchaseDetail(purchaseId), "");
        return StdData.ok().build();
    }

    @PostMapping(value={"/test/task"})
    public StdData<?> testTask(@RequestBody Map<String, String> request) {
        List buckets = this.bucketRepository.findAll();
        for (Bucket bucket : buckets) {
            this.statsDiskRepository.diskStats(bucket.getName());
        }
        this.resourceGoodsBizService.updateOccupiedCapacity(request.get("date"));
        return StdData.ok().build();
    }

    @GetMapping(value={"/test"})
    public StdData<?> test(@RequestParam String id) {
        this.resourceGoodsRepository.deleteById(id);
        this.resourceGoodsPurchaseRecordRepository.deleteById(id);
        return StdData.ok().build();
    }

    @GetMapping(value={"/test2"})
    public StdData<?> test2() {
        this.resourceGoodsUseRecordRepository.dropCollection();
        return StdData.ok().build();
    }

    private ResourceGoodsVO buildResourceGoodsVO(ResourceGoods resourceGoods) {
        if (resourceGoods == null) {
            return null;
        }
        ResourceGoodsVO resourceGoodsVO = new ResourceGoodsVO();
        resourceGoodsVO.setProductCode(resourceGoods.getProductCode());
        resourceGoodsVO.setAppId(resourceGoods.getAppId());
        resourceGoodsVO.setId(resourceGoods.getId().toString());
        resourceGoodsVO.setCreateBy(resourceGoods.getCreateBy());
        resourceGoodsVO.setCreateById(resourceGoods.getCreateById());
        resourceGoodsVO.setCreateDate(resourceGoods.getCreateDate());
        resourceGoodsVO.setModifyBy(resourceGoods.getModifyBy());
        resourceGoodsVO.setModifyById(resourceGoods.getModifyById());
        resourceGoodsVO.setModifyDate(resourceGoods.getModifyDate());
        return resourceGoodsVO;
    }

    private ResourceGoodsUseRecordVO buildResourceGoodsUseRecordVO(ResourceGoodsUseRecord resourceGoodsUseRecord) {
        if (resourceGoodsUseRecord == null) {
            return null;
        }
        ResourceGoodsUseRecordVO resourceGoodsUseRecordVO = new ResourceGoodsUseRecordVO();
        resourceGoodsUseRecordVO.setProductCode(resourceGoodsUseRecord.getProductCode());
        resourceGoodsUseRecordVO.setProductName(resourceGoodsUseRecord.getProductName());
        resourceGoodsUseRecordVO.setAppId(resourceGoodsUseRecord.getAppId());
        resourceGoodsUseRecordVO.setBucket(resourceGoodsUseRecord.getBucket());
        resourceGoodsUseRecordVO.setTenantId(resourceGoodsUseRecord.getTenantId());
        resourceGoodsUseRecordVO.setPurchaseId(resourceGoodsUseRecord.getPurchaseId());
        resourceGoodsUseRecordVO.setOccupiedCapacity(resourceGoodsUseRecord.getOccupiedCapacity());
        resourceGoodsUseRecordVO.setId(resourceGoodsUseRecord.getId().toString());
        resourceGoodsUseRecordVO.setCreateBy(resourceGoodsUseRecord.getCreateBy());
        resourceGoodsUseRecordVO.setCreateById(resourceGoodsUseRecord.getCreateById());
        resourceGoodsUseRecordVO.setCreateDate(resourceGoodsUseRecord.getCreateDate());
        resourceGoodsUseRecordVO.setModifyBy(resourceGoodsUseRecord.getModifyBy());
        resourceGoodsUseRecordVO.setModifyById(resourceGoodsUseRecord.getModifyById());
        resourceGoodsUseRecordVO.setModifyDate(resourceGoodsUseRecord.getModifyDate());
        return resourceGoodsUseRecordVO;
    }

    private ResourceGoodsPurchaseRecordVO buildResourceGoodsPurchaseRecordVO(ResourceGoodsPurchaseRecord resourceGoodsPurchaseRecord) {
        if (resourceGoodsPurchaseRecord == null) {
            return null;
        }
        ResourceGoodsPurchaseRecordVO resourceGoodsPurchaseRecordVO = new ResourceGoodsPurchaseRecordVO();
        resourceGoodsPurchaseRecordVO.setProductCode(resourceGoodsPurchaseRecord.getProductCode());
        resourceGoodsPurchaseRecordVO.setProductName(resourceGoodsPurchaseRecord.getProductName());
        resourceGoodsPurchaseRecordVO.setTenantId(resourceGoodsPurchaseRecord.getTenantId());
        resourceGoodsPurchaseRecordVO.setTotalUsageCapacity(resourceGoodsPurchaseRecord.getTotalUsageCapacity());
        resourceGoodsPurchaseRecordVO.setOccupiedCapacity(resourceGoodsPurchaseRecord.getOccupiedCapacity());
        resourceGoodsPurchaseRecordVO.setRemark(resourceGoodsPurchaseRecord.getRemark());
        resourceGoodsPurchaseRecordVO.setPurchaseId(resourceGoodsPurchaseRecord.getPurchaseId());
        resourceGoodsPurchaseRecordVO.setPurchaseDate(resourceGoodsPurchaseRecord.getPurchaseDate());
        resourceGoodsPurchaseRecordVO.setEffectiveDateTime(resourceGoodsPurchaseRecord.getEffectiveDateTime());
        resourceGoodsPurchaseRecordVO.setExpiredDateTime(resourceGoodsPurchaseRecord.getExpiredDateTime());
        resourceGoodsPurchaseRecordVO.setId(resourceGoodsPurchaseRecord.getId().toString());
        resourceGoodsPurchaseRecordVO.setCreateBy(resourceGoodsPurchaseRecord.getCreateBy());
        resourceGoodsPurchaseRecordVO.setCreateById(resourceGoodsPurchaseRecord.getCreateById());
        resourceGoodsPurchaseRecordVO.setCreateDate(resourceGoodsPurchaseRecord.getCreateDate());
        resourceGoodsPurchaseRecordVO.setModifyBy(resourceGoodsPurchaseRecord.getModifyBy());
        resourceGoodsPurchaseRecordVO.setModifyById(resourceGoodsPurchaseRecord.getModifyById());
        resourceGoodsPurchaseRecordVO.setModifyDate(resourceGoodsPurchaseRecord.getModifyDate());
        return resourceGoodsPurchaseRecordVO;
    }
}

