/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.admin.ParamCheckService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Collections;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class BucketController {
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private ParamCheckService paramCheckService;

    @RoleAuthorize
    @PostMapping(value={"/buckets"})
    public ResponseEntity<?> create(@Valid @RequestBody Bucket body, @RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        if (ObjectUtils.isEmpty((Object)body.getOwner())) {
            body.setOwner(userInfo.getUserId());
        }
        this.paramCheckService.newBucket(body);
        if (userInfo.getIam().booleanValue()) {
            body.setTenantId(userInfo.getTenant());
        }
        String id = this.bucketRepository.insert((ObIdEntity)body);
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @RoleAuthorize
    @GetMapping(value={"/buckets"})
    public ResponseEntity<?> getByUser(@RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        return ResponseEntity.ok((Object)this.bucketRepository.findByOwner(userInfo.getUserId()));
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/buckets/All"})
    public ResponseEntity<?> getAll() {
        return ResponseEntity.ok((Object)this.bucketRepository.findAll());
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/buckets/{bucket}/isExist"})
    public ResponseEntity<?> isExist(@PathVariable String bucket) {
        return ResponseEntity.ok(Collections.singletonMap("isExist", this.bucketRepository.existsByName(bucket)));
    }

    @GetMapping(value={"/buckets/hasapi"})
    public ResponseEntity<?> getHasApiByUser(@RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        return ResponseEntity.ok((Object)this.bucketRepository.findByOwnerAndApiUrlNotNull(userInfo.getUserId()));
    }

    @GetMapping(value={"/buckets/hasapi/all"})
    public ResponseEntity<?> getHasApi() {
        return ResponseEntity.ok((Object)this.bucketRepository.findByApiUrlNotNull());
    }

    @RoleAuthorize
    @PostMapping(value={"/buckets/modifyapi"})
    public ResponseEntity<?> modifyApiUrlById(@RequestBody Bucket body) {
        Bucket bucket = (Bucket)this.bucketRepository.findById(body.getId());
        if (bucket == null) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, new Object[]{body.getId()});
        }
        bucket.setApiUrl(body.getApiUrl());
        this.bucketRepository.update((ObIdEntity)bucket);
        return ResponseEntity.ok((Object)bucket);
    }
}

