/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.admin.ParamCheckService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Collections;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class UserController {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ParamCheckService paramCheckService;

    @RoleAuthorize(owner=false, admin=true)
    @PostMapping(value={"/users"})
    public ResponseEntity<?> createUser(@Valid @RequestBody User user) {
        this.paramCheckService.newUser(user);
        String id = this.userRepository.insert((ObIdEntity)user);
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/users"})
    public ResponseEntity<?> getAll() {
        return ResponseEntity.ok((Object)this.userRepository.findAll());
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/users/{name}"})
    public ResponseEntity<?> getByName(@PathVariable String name) {
        User user = this.userRepository.findByName(name);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NONE, new Object[]{name});
        }
        return ResponseEntity.ok((Object)user);
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/users/{name}/isExist"})
    public ResponseEntity<?> isExist(@PathVariable String name) {
        return ResponseEntity.ok(Collections.singletonMap("isExist", this.userRepository.existsByName(name)));
    }

    @RoleAuthorize(owner=false, admin=true)
    @DeleteMapping(value={"/users/{id}"})
    public ResponseEntity<?> del(@PathVariable String id) {
        this.userRepository.deleteById(id);
        return ResponseEntity.ok(Collections.singletonMap("isExist", true));
    }

    @RoleAuthorize(owner=false, admin=true)
    @PutMapping(value={"/users"})
    public StdData<?> modify(@RequestBody User body) {
        User dbUser = (User)this.userRepository.findById(body.getId());
        if (dbUser != null) {
            dbUser.setDisplayName(body.getDisplayName());
            dbUser.setBuiltinRole(body.getBuiltinRole());
            this.userRepository.update((ObIdEntity)dbUser);
        }
        return StdData.ok((Object)dbUser);
    }
}

