/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.stats;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsApi;
import com.digiwin.dap.middleware.dmc.repository.StatsApiRepository;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/stats/api"})
public class StatsApiApi {
    @Autowired
    private StatsApiRepository statsApiRepository;

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.statsApiRepository.findByPage(body));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.statsApiRepository.deleteById(id);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/drop"})
    public StdData<?> dropCollection() {
        this.statsApiRepository.dropCollection();
        return StdData.ok().build();
    }

    @PostMapping
    public StdData<?> stats(@RequestBody StatsApi body) {
        this.statsApiRepository.visitStats(body.getDate());
        return StdData.ok().build();
    }
}

