/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.stats;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.dmc.domain.excel.StatsDiskExcel;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsDiskVO;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsDisk;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.StatsDiskRepository;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.serializer.Constants;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/dmc/v2/stats/disk"})
public class StatsDiskApi {
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private StatsDiskRepository statsDiskRepository;

    private static void handleDate(Map<String, Object> filters) {
        LocalDate nowDay = LocalDate.now().withDayOfMonth(1);
        try {
            String startDateStr = filters.getOrDefault("startDate", "").toString();
            LocalDate startDate = LocalDate.parse(startDateStr, Constants.DATE_FORMATTER);
            filters.put("startDate", startDate.withDayOfMonth(1));
        }
        catch (Exception e) {
            filters.put("startDate", nowDay.minusMonths(1L));
        }
        try {
            String endDateStr = filters.getOrDefault("endDate", "").toString();
            LocalDate endDate = LocalDate.parse(endDateStr, Constants.DATE_FORMATTER);
            filters.put("endDate", endDate.withDayOfMonth(1));
        }
        catch (Exception e) {
            filters.put("endDate", nowDay);
        }
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        PageData page = this.statsDiskRepository.findByPage(body);
        List list = page.getList().stream().map(StatsDiskVO::new).collect(Collectors.toList());
        return StdData.ok((Object)PageData.data((long)page.getTotal(), list));
    }

    @PostMapping(value={"/console/search"})
    public StdData<?> searchConsole(@RequestBody(required=false) Page body) {
        body.getFilters().put("tenantId", UserUtils.getTenantId());
        PageData page = this.statsDiskRepository.findByPage(body);
        List list = page.getList().stream().map(StatsDiskVO::new).collect(Collectors.toList());
        return StdData.ok((Object)PageData.data((long)page.getTotal(), list));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.statsDiskRepository.deleteById(id);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/drop"})
    public StdData<?> dropCollection() {
        this.statsDiskRepository.dropCollection();
        return StdData.ok().build();
    }

    @PostMapping(value={"/export"})
    public void export(@RequestBody(required=false) Page body, HttpServletResponse response) throws Exception {
        List statsDisks = this.statsDiskRepository.findByCond(body);
        List statsDiskExcels = statsDisks.stream().map(StatsDiskExcel::new).collect(Collectors.toList());
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.equals(LocaleContextHolder.getLocale()) ? this.getClass().getResourceAsStream("/static/templates/stats_disk_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/stats_disk_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u6587\u6863\u7528\u91cf\u660e\u7ec6_" + LocalDate.now(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), StatsDiskExcel.class).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(statsDiskExcels);
    }

    @PostMapping
    public StdData<?> stats(@RequestBody StatsDisk body) {
        if (StringUtils.hasText((String)body.getBucket())) {
            this.statsDiskRepository.diskStats(body.getBucket());
        } else {
            List buckets = this.bucketRepository.findAll();
            for (Bucket bucket : buckets) {
                this.statsDiskRepository.diskStats(bucket.getName());
            }
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody StatsDisk body, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        Bucket bucket = this.bucketRepository.findByName(body.getBucket());
        if (bucket == null || !Objects.equals(bucket.getAppId(), sys.getId())) {
            return StdData.ok().build();
        }
        List statsDisks = this.statsDiskRepository.findByCond(body.getYear(), body.getMonth(), sys.getId(), body.getBucket(), body.getTenantId());
        return StdData.ok((Object)statsDisks);
    }

    @PostMapping(value={"/bucket"})
    public StdData<?> statsByBucket(@RequestBody(required=false) Page body) {
        StatsDiskApi.handleDate((Map)body.getFilters());
        return StdData.ok((Object)this.statsDiskRepository.diskStats4Bucket(body));
    }

    @PostMapping(value={"/tenant"})
    public StdData<?> statsByTenant(@RequestBody(required=false) Page body) {
        StatsDiskApi.handleDate((Map)body.getFilters());
        return StdData.ok((Object)this.statsDiskRepository.diskStats4Tenant(body));
    }
}

