/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.stats;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.stats.StatsVisitLog;
import com.digiwin.dap.middleware.dmc.repository.StatsVisitLogRepository;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/stats/visit/log"})
public class StatsVisitLogApi {
    @Autowired
    private StatsVisitLogRepository statsVisitLogRepository;

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.statsVisitLogRepository.deleteById(id);
        return StdData.ok().build();
    }

    @PutMapping
    public StdData<?> modify(@RequestBody StatsVisitLog body) {
        this.statsVisitLogRepository.update((ObIdEntity)body);
        return StdData.ok((Object)this.statsVisitLogRepository.findById(body.getId()));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        PageData page = this.statsVisitLogRepository.findByPage(body);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("total", page.getTotal());
        data.put("list", page.getList());
        if (body.getFilters().containsKey("statsSize") && ((Boolean)body.getFilters().get("statsSize")).booleanValue()) {
            long fileSize = this.statsVisitLogRepository.fileSizeStats(body.getFilters());
            data.put("fileSize", fileSize);
        }
        return StdData.ok(data);
    }

    @DeleteMapping(value={"/drop"})
    public StdData<?> dropCollection() {
        this.statsVisitLogRepository.dropCollection();
        return StdData.ok().build();
    }
}

