/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.RoleEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.UserEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.UserType;
import com.digiwin.dap.middleware.dmc.domain.select.Option;
import com.digiwin.dap.middleware.dmc.domain.select.Options;
import com.digiwin.dap.middleware.dmc.domain.v2.BucketVO;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.BucketUser;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.obsolete.service.BucketUserService;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.BucketUserRepository;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.admin.ParamCheckService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.remote.IamService;
import com.digiwin.dap.middleware.dmc.support.remote.MailService;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import com.mongodb.MongoNamespace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/dmc/v2/buckets"})
public class BucketApi {
    @Autowired
    private IamService iamService;
    @Autowired
    private MailService mailService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private BucketUserService bucketUserService;
    @Autowired
    private ParamCheckService paramCheckService;
    @Autowired
    private BucketUserRepository bucketUserRepository;

    private static List<Bucket> sorted(List<Bucket> buckets) {
        return buckets.stream().sorted(Comparator.comparing(Bucket::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    private void updateOwner(Bucket body) {
        this.bucketUserService.saveUsers(body.getName(), body.getOwners(), UserType.IAM.ordinal());
        this.bucketUserService.saveUsers(body.getName(), body.getAdmins(), UserType.ADMIN.ordinal());
        body.setOwners(new ArrayList());
        body.setAdmins(new ArrayList());
    }

    @PostMapping
    public StdData<?> create(@RequestBody Bucket body) {
        this.paramCheckService.newBucket(body);
        this.updateOwner(body);
        String id = this.bucketRepository.insert((ObIdEntity)body);
        this.mailService.notifyByEmail(body, Integer.valueOf(0));
        return StdData.ok((Object)this.bucketRepository.findById(id));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        Bucket bucket = (Bucket)this.bucketRepository.findById(id);
        if (bucket != null) {
            this.bucketRepository.deleteById(bucket.getId());
            this.bucketUserService.deleteUsers(bucket.getName());
        }
        return StdData.ok().build();
    }

    @PutMapping
    public StdData<?> modify(@RequestBody Bucket body) {
        Bucket bucket = (Bucket)this.bucketRepository.findById(body.getId());
        if (bucket != null) {
            if (!Objects.equals(bucket.getName(), body.getName())) {
                throw new BusinessException((ErrorHandler)I18nError.BUCKET_NAME_CHANGE_DENY);
            }
            this.updateOwner(body);
            UserUtil.setModifyFields((ObIdEntity)body);
            this.bucketRepository.replace((ObIdEntity)body);
            if (body.getQuotaSize() > bucket.getQuotaSize()) {
                this.mailService.notifyByEmail(body, Integer.valueOf(0));
            }
        }
        return StdData.ok((Object)this.bucketRepository.findById(body.getId()));
    }

    @GetMapping(value={"/{id}"})
    public StdData<?> findById(@PathVariable String id) {
        return StdData.ok((Object)this.bucketRepository.findById(id));
    }

    @GetMapping
    public StdData<?> find(@RequestBody(required=false) Bucket body) {
        return StdData.ok((Object)this.bucketRepository.findAll((ObIdEntity)body));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        PageData pageData = this.bucketRepository.findByPage(body);
        for (Bucket bucket : pageData.getList()) {
            List ownerUsers = this.bucketUserRepository.findByBucketAndType(bucket.getName(), UserType.IAM.ordinal());
            List adminUsers = this.bucketUserRepository.findByBucketAndType(bucket.getName(), UserType.ADMIN.ordinal());
            bucket.setOwners(ownerUsers.stream().map(BucketUser::getUserId).collect(Collectors.toList()));
            bucket.setAdmins(adminUsers.stream().map(BucketUser::getUserId).collect(Collectors.toList()));
        }
        return StdData.ok((Object)pageData);
    }

    @GetMapping(value={"/name/{bucket}"})
    public StdData<?> findByName(@PathVariable String bucket) {
        return StdData.ok((Object)this.bucketRepository.findByName(bucket));
    }

    @PostMapping(value={"/name"})
    public StdData<?> updateByName(@RequestBody Bucket body) {
        Bucket bucket = this.bucketRepository.findByName(body.getName());
        if (bucket == null) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, new Object[]{body.getName()});
        }
        bucket.setDescription(body.getDescription());
        bucket.setRetain(body.getRetain());
        bucket.setBackup(body.getBackup());
        this.bucketRepository.update((ObIdEntity)bucket);
        return StdData.ok((Object)bucket);
    }

    @PostMapping(value={"/register"})
    public StdData<?> registerBucket(@RequestBody BucketVO body, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) JwtUser userInfo) {
        MongoNamespace.checkDatabaseNameValidity((String)body.getBucket());
        Bucket oldBucket = this.bucketRepository.findByName(body.getBucket());
        if (oldBucket != null) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_EXISTS, new Object[]{body.getBucket()});
        }
        boolean isIam = userInfo != null && userInfo.getIam() != false;
        String owner = body.getOwner();
        String displayName = userInfo == null ? owner : userInfo.getUserName();
        List<Object> owners = isIam ? Collections.singletonList(owner) : Collections.emptyList();
        User user = this.userRepository.findByName(owner);
        if (user == null) {
            user = new User();
            user.setName(owner);
            user.setDisplayName(displayName);
            user.setPwdHash(DigestUtils.sha256((String)owner, (int)2));
            user.setBuiltinRole(RoleEnum.BucketCreator.name());
            this.userRepository.insert((ObIdEntity)user);
        }
        Bucket bucket = new Bucket();
        bucket.setName(body.getBucket());
        bucket.setDescription(body.getDescription());
        bucket.setOwner(owner);
        bucket.setAppId(body.getAppId());
        bucket.setOwners(owners);
        bucket.flushKey();
        this.bucketRepository.insert((ObIdEntity)bucket);
        if (isIam) {
            BucketUser bucketUser = new BucketUser(owner, body.getBucket());
            bucketUser.setRole(Integer.valueOf(UserEnum.Owner.ordinal()));
            this.bucketUserRepository.insert((ObIdEntity)bucketUser);
        }
        LinkedHashMap<String, String> register = new LinkedHashMap<String, String>();
        register.put("username", user.getName());
        register.put("password", user.getPwdHash());
        return StdData.ok(register);
    }

    @Deprecated
    @PostMapping(value={"/apply"})
    public StdData<?> applyBucket(@RequestBody BucketVO body) {
        User oldCheck;
        MongoNamespace.checkDatabaseNameValidity((String)body.getBucket());
        if (StringUtils.isEmpty((Object)body.getOwner())) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_OWNER_NONE, new Object[]{body.getBucket()});
        }
        if (StringUtils.isEmpty((Object)body.getPassword())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_PASSWORD_NONE);
        }
        String pwdHash = DigestUtils.sha256((String)body.getPassword(), (int)2);
        User oldUser = this.userRepository.findByName(body.getOwner());
        if (oldUser != null && (oldCheck = this.userRepository.findByNameAndPwdHash(body.getOwner(), pwdHash)) == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_PASSWORD_CHECK_FAIL);
        }
        Bucket oldBucket = this.bucketRepository.findByName(body.getBucket());
        if (oldBucket != null) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_EXISTS, new Object[]{body.getBucket()});
        }
        Bucket bucket = new Bucket();
        bucket.setName(body.getBucket());
        bucket.setOwner(body.getOwner());
        bucket.setVersionNum("1");
        bucket.setDescription(body.getDescription());
        bucket.flushKey();
        this.bucketRepository.insert((ObIdEntity)bucket);
        if (oldUser == null) {
            User user = new User();
            user.setName(body.getOwner());
            user.setDisplayName(body.getOwner());
            user.setPwdHash(pwdHash);
            user.setBuiltinRole(RoleEnum.BucketCreator.name());
            this.userRepository.insert((ObIdEntity)user);
        }
        return StdData.ok((Object)pwdHash);
    }

    @PostMapping(value={"/task"})
    public StdData<?> modifyTask(@RequestBody BucketVO body) {
        Bucket bucket = this.bucketRepository.findByName(body.getBucket());
        this.bucketRepository.update((ObIdEntity)bucket);
        return StdData.ok((Object)bucket);
    }

    @PostMapping(value={"/edit"})
    public StdData<?> modify(@RequestBody BucketVO body) {
        Bucket bucket = this.bucketRepository.findByName(body.getBucket());
        bucket.setDescription(body.getDescription());
        bucket.setApiUrl(body.getApiUrl());
        bucket.setVersionNum(body.getVersionNum());
        bucket.setTenantId(body.getTenantId());
        this.bucketRepository.update((ObIdEntity)bucket);
        return StdData.ok((Object)bucket);
    }

    @PostMapping(value={"encrypted/storage/open/edit"})
    public StdData<?> openEncryptedStorage(@RequestBody BucketVO body) {
        Bucket bucket = this.bucketRepository.findByName(body.getBucket());
        bucket.setEncryptedStorage(Boolean.valueOf(true));
        this.bucketRepository.update((ObIdEntity)bucket);
        return StdData.ok((Object)bucket);
    }

    @PostMapping(value={"encrypted/storage/close/edit"})
    public StdData<?> closeEncryptedStorage(@RequestBody BucketVO body) {
        Bucket bucket = this.bucketRepository.findByName(body.getBucket());
        bucket.setEncryptedStorage(Boolean.valueOf(false));
        this.bucketRepository.update((ObIdEntity)bucket);
        return StdData.ok((Object)bucket);
    }

    @GetMapping(value={"/owner"})
    public StdData<?> owner() {
        return StdData.ok((Object)this.bucketRepository.findByOwner(UserUtils.getUserId()));
    }

    @GetMapping(value={"/task"})
    public StdData<?> bucketTasks() {
        return StdData.ok(Collections.emptyList());
    }

    @GetMapping(value={"/enable/option"})
    public StdData<?> bucketSelect() {
        List apps = this.iamService.getApp();
        Set appIds = this.bucketRepository.findAll().stream().map(Bucket::getAppId).collect(Collectors.toSet());
        return StdData.ok(apps.stream().filter(o -> !appIds.contains(o.getId())).map(Option::new).collect(Collectors.toList()));
    }

    @GetMapping(value={"/option"})
    public StdData<?> bucketSelect(@RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        List joins;
        ArrayList<Options> optionGroup = new ArrayList<Options>();
        UserType userType = userInfo.getIam().booleanValue() ? (this.envProperties.isCoa() ? UserType.COA : UserType.IAM) : UserType.ADMIN;
        List buckets = BucketApi.sorted((List)this.bucketRepository.findAll());
        List owners = buckets.stream().filter(o -> o.getOwner().equals(userInfo.getUserId())).collect(Collectors.toList());
        buckets.removeAll(owners);
        Options ownersOption = new Options(4L, "\u6211\u521b\u5efa\u7684");
        ownersOption.getOptions().addAll(owners.stream().map(Option::new).collect(Collectors.toList()));
        optionGroup.add(ownersOption);
        if (userType == UserType.COA) {
            List bucketNames = this.iamService.getTenantIds(userInfo.getToken());
            joins = this.bucketRepository.findByNames(bucketNames);
        } else {
            List members = this.bucketUserService.findBuckets(userInfo.getUserId(), userType.ordinal());
            joins = buckets.stream().filter(o -> members.contains(o.getName())).collect(Collectors.toList());
        }
        buckets.removeAll(joins);
        Options joinsOption = new Options(3L, "\u6211\u52a0\u5165\u7684");
        joinsOption.getOptions().addAll(joins.stream().map(Option::new).collect(Collectors.toList()));
        optionGroup.add(joinsOption);
        if (userType == UserType.IAM) {
            List appIds = this.iamService.getTenantAppId(userInfo.getToken());
            List apps = this.bucketRepository.findByAppIds(appIds);
            buckets.removeAll(apps);
            Options appsOption = new Options(2L, "\u79df\u6237\u7684");
            appsOption.getOptions().addAll(apps.stream().map(Option::new).collect(Collectors.toList()));
            optionGroup.add(appsOption);
        }
        if (userInfo.getAdmin().booleanValue()) {
            Options adminOption = new Options(1L, "\u5168\u90e8\u7684");
            adminOption.getOptions().addAll(buckets.stream().map(Option::new).collect(Collectors.toList()));
            optionGroup.add(adminOption);
        }
        return StdData.ok(optionGroup.stream().sorted(Comparator.comparing(Options::getKey).reversed()).collect(Collectors.toList()));
    }

    @PostMapping(value={"/register/mail"})
    public StdData<?> registerMail(@RequestBody BucketVO body, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) JwtUser userInfo) {
        Bucket bucket = this.bucketRepository.findByName(body.getBucket());
        User user = this.userRepository.findByName(bucket.getOwner());
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("bucket", bucket.getName());
        results.put("username", user.getName());
        results.put("email", user.getEmail());
        results.put("pwdHash", user.getPwdHash());
        results.put("dmcUri", this.envProperties.getDmcUri());
        this.mailService.register(results);
        return StdData.ok(results);
    }
}

