/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.UserType;
import com.digiwin.dap.middleware.dmc.domain.v2.BucketUsers;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.objectid.BucketUser;
import com.digiwin.dap.middleware.dmc.obsolete.service.BucketUserService;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.repository.BucketUserRepository;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/bucket/users"})
public class BucketUserApi {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private BucketUserService bucketUserService;
    @Autowired
    private BucketUserRepository bucketUserRepository;

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.bucketUserRepository.deleteById(id);
        return StdData.ok().build();
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.bucketUserRepository.findByPage(body));
    }

    @PostMapping(value={"/user"})
    public StdData<?> findUser(@RequestBody BucketUser body) {
        List bucketUsers = this.bucketUserRepository.findByBucketAndType(body.getBucket(), UserType.ADMIN.ordinal());
        List users = this.userRepository.findByNames(bucketUsers.stream().map(BucketUser::getUserId).collect(Collectors.toList()));
        return StdData.ok((Object)users);
    }

    @PostMapping(value={"/bucket"})
    public StdData<?> findBucket(@RequestBody BucketUser body) {
        List bucketUsers = this.bucketUserRepository.findByUserIdAndType(body.getUserId(), UserType.ADMIN.ordinal());
        List buckets = this.bucketRepository.findByNames(bucketUsers.stream().map(BucketUser::getUserId).collect(Collectors.toList()));
        return StdData.ok((Object)buckets);
    }

    @PostMapping(value={"/bind"})
    public StdData<?> bindBucketUser(@RequestBody @Valid BucketUsers body) {
        List buckets = this.bucketRepository.findByNames(body.getBuckets());
        if (buckets.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, body.getBuckets().toArray());
        }
        List names = buckets.stream().map(Bucket::getName).collect(Collectors.toList());
        List notNames = body.getBuckets().stream().filter(name -> !names.contains(name)).collect(Collectors.toList());
        if (!notNames.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.BUCKET_NONE, notNames.toArray());
        }
        for (Bucket bucket : buckets) {
            this.bucketUserService.saveUsers(bucket.getName(), body.getOwners(), UserType.IAM.ordinal());
            this.bucketUserService.saveUsers(bucket.getName(), body.getAdmins(), UserType.ADMIN.ordinal());
        }
        return StdData.ok().build();
    }
}

