/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.dmc.domain.v2.BucketStats;
import com.digiwin.dap.middleware.dmc.domain.v2.FileStats;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.objectid.Stats;
import com.digiwin.dap.middleware.dmc.repository.StatsRepository;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/dmc/v2/stats"})
public class StatsApi {
    @Autowired
    private StatsRepository statsRepository;

    private static boolean filterBucket(String bucket, String name) {
        return ObjectUtils.isEmpty((Object)bucket) || bucket.equals(name);
    }

    @GetMapping
    public StdData<?> stats() {
        return StdData.ok((Object)this.statsRepository.findAll());
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.statsRepository.findByPage(body));
    }

    @DeleteMapping(value={"/drop"})
    public StdData<?> dropCollection() {
        this.statsRepository.dropCollection();
        return StdData.ok().build();
    }

    @GetMapping(value={"/increment/{prev}/{next}"})
    public StdData<?> increment(@PathVariable String prev, @PathVariable String next) {
        return StdData.ok((Object)this.statsRepository.getBucketInc(prev, next));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.statsRepository.deleteById(id);
        return StdData.ok().build();
    }

    @GetMapping(value={"/count"})
    public StdData<?> count() {
        return StdData.ok((Object)this.statsRepository.findNewest());
    }

    @GetMapping(value={"/total"})
    public StdData<?> total(@RequestParam(value="bucket", required=false) String bucket, @RequestParam(value="limit", defaultValue="10") Long limit) {
        Stats stats = this.statsRepository.findNewest();
        List buckets = stats.getBuckets();
        List<BucketStats> buckets1 = buckets.stream().filter(p -> StatsApi.filterBucket((String)bucket, (String)p.getName())).sorted(Comparator.comparing(BucketStats::getTotalSize).reversed()).limit(limit).collect(Collectors.toList());
        ArrayList bucketSizes = new ArrayList();
        ArrayList sizes = new ArrayList();
        buckets1.forEach(o -> {
            bucketSizes.add(o.getName());
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("value", DataUtil.byte2Gb((long)o.getTotalSize()));
            temp.put("name", o.getName());
            sizes.add(temp);
        });
        List<BucketStats> buckets2 = buckets.stream().filter(p -> StatsApi.filterBucket((String)bucket, (String)p.getName())).sorted(Comparator.comparing(BucketStats::getTotalCount).reversed()).limit(limit).collect(Collectors.toList());
        ArrayList bucketFiles = new ArrayList();
        ArrayList files = new ArrayList();
        buckets2.forEach(o -> {
            bucketFiles.add(o.getName());
            files.add(o.getTotalCount());
        });
        HashMap result = new HashMap();
        result.put("bucketSizes", bucketSizes);
        result.put("sizes", sizes);
        result.put("bucketFiles", bucketFiles);
        result.put("files", files);
        return StdData.ok(result);
    }

    @GetMapping(value={"/file"})
    public StdData<?> file(@RequestParam(value="bucket", required=false) String bucket, @RequestParam(value="limit", defaultValue="10") Long limit) {
        Stats stats = this.statsRepository.findNewest();
        List buckets = stats.getBuckets().stream().filter(p -> StatsApi.filterBucket((String)bucket, (String)p.getName())).sorted(Comparator.comparing(BucketStats::getFileCount).reversed()).limit(limit).collect(Collectors.toList());
        ArrayList results = new ArrayList();
        for (BucketStats bucketStats : buckets) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (bucketStats == null) continue;
            List counts = bucketStats.getFileStats().stream().map(FileStats::getCount).collect(Collectors.toList());
            result.put("bucket", bucketStats.getName());
            result.put("sizes", FileStats.defaults.keySet());
            result.put("counts", counts);
            results.add(result);
        }
        return StdData.ok(results);
    }
}

