/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.BucketConfig;
import com.digiwin.dap.middleware.dmc.repository.BucketConfigRepository;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/storage/config"})
public class StorageConfigApi {
    @Autowired
    private BucketConfigRepository bucketConfigRepository;

    @PostMapping
    public StdData<?> create(@RequestBody BucketConfig body) {
        String id = this.bucketConfigRepository.insert((ObIdEntity)body);
        return StdData.ok((Object)this.bucketConfigRepository.findById(id));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.bucketConfigRepository.deleteById(id);
        return StdData.ok().build();
    }

    @PutMapping
    public StdData<?> modify(@RequestBody BucketConfig body) {
        this.bucketConfigRepository.update((ObIdEntity)body);
        return StdData.ok((Object)this.bucketConfigRepository.findById(body.getId()));
    }

    @GetMapping(value={"/{id}"})
    public StdData<?> findById(@PathVariable String id) {
        return StdData.ok((Object)this.bucketConfigRepository.findById(id));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.bucketConfigRepository.findByPage(body));
    }
}

