/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/tasks"})
public class TaskApi {
    @Autowired
    private TaskRepository taskRepository;

    @PostMapping
    public StdData<?> create(@RequestBody Task body) {
        String id = this.taskRepository.insert((ObIdEntity)body);
        return StdData.ok((Object)this.taskRepository.findById(id));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.taskRepository.deleteById(id);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/drop"})
    public StdData<?> dropCollection() {
        this.taskRepository.dropCollection();
        return StdData.ok().build();
    }

    @PutMapping
    public StdData<?> modify(@RequestBody Task body) {
        this.taskRepository.update((ObIdEntity)body);
        return StdData.ok((Object)this.taskRepository.findById(body.getId()));
    }

    @GetMapping(value={"/{id}"})
    public StdData<?> findById(@PathVariable String id) {
        return StdData.ok((Object)this.taskRepository.findById(id));
    }

    @GetMapping
    public StdData<?> find(@RequestBody(required=false) Task body) {
        return StdData.ok((Object)this.taskRepository.findAll((ObIdEntity)body));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.taskRepository.findByPage(body));
    }
}

