/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.dmc.entity.objectid.Task;
import com.digiwin.dap.middleware.dmc.repository.TaskRepository;
import com.digiwin.dap.middleware.dmc.support.schedule.TaskManagerService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/tasks"})
public class TaskManagerApi {
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private TaskManagerService taskManagerService;

    @GetMapping(value={"/start/{code}"})
    public StdData<?> start(@PathVariable String code) {
        return StdData.ok((Object)this.taskManagerService.start(code));
    }

    @GetMapping(value={"/stop/{code}"})
    public StdData<?> stop(@PathVariable String code) {
        return StdData.ok((Object)this.taskManagerService.stop(code));
    }

    @GetMapping(value={"/refresh"})
    public StdData<?> refresh() {
        this.taskManagerService.refresh();
        return StdData.ok().build();
    }

    @GetMapping(value={"/run/{id}"})
    public StdData<?> run(@PathVariable String id) throws Exception {
        Task task = (Task)this.taskRepository.findById(id);
        this.taskManagerService.doTask(task.getClassName());
        return StdData.ok().build();
    }
}

