/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.admin.v2;

import com.digiwin.dap.middleware.dmc.domain.enumeration.RoleEnum;
import com.digiwin.dap.middleware.dmc.domain.select.Option;
import com.digiwin.dap.middleware.dmc.domain.select.Options;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PasswordVO;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.User;
import com.digiwin.dap.middleware.dmc.repository.UserRepository;
import com.digiwin.dap.middleware.dmc.service.admin.ParamCheckService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/users"})
public class UserApi {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ParamCheckService paramCheckService;

    @PostMapping
    public StdData<?> create(@RequestBody User body) {
        this.paramCheckService.newUser(body);
        String id = this.userRepository.insert((ObIdEntity)body);
        return StdData.ok((Object)this.userRepository.findById(id));
    }

    @DeleteMapping(value={"/{id}"})
    public StdData<?> delete(@PathVariable String id) {
        this.userRepository.deleteById(id);
        return StdData.ok().build();
    }

    @PutMapping
    public StdData<?> modify(@RequestBody User body) {
        User user = (User)this.userRepository.findById(body.getId());
        if (user != null) {
            user.setDisplayName(body.getDisplayName());
            user.setEmail(body.getEmail());
            user.setBuiltinRole(body.getBuiltinRole());
            this.userRepository.update((ObIdEntity)body);
        }
        return StdData.ok((Object)user);
    }

    @PutMapping(value={"/name"})
    public StdData<?> modifyName(@RequestBody User body) {
        User user = (User)this.userRepository.findById(body.getId());
        if (user != null) {
            user.setDisplayName(body.getDisplayName());
            this.userRepository.update((ObIdEntity)user);
        }
        return StdData.ok((Object)user);
    }

    @GetMapping(value={"/{id}"})
    public StdData<?> findById(@PathVariable String id) {
        return StdData.ok((Object)this.userRepository.findById(id));
    }

    @GetMapping
    public StdData<?> find(@RequestBody(required=false) User body) {
        return StdData.ok((Object)this.userRepository.findAll((ObIdEntity)body));
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.userRepository.findByPage(body));
    }

    @PostMapping(value={"/password/check"})
    public StdData<?> checkPassword(@RequestBody PasswordVO body) {
        User user = this.userRepository.findByName(body.getName());
        if (user.getPwdHash().equals(body.getPwdHash())) {
            return StdData.ok((Object)true);
        }
        return StdData.ok((Object)false);
    }

    @PostMapping(value={"/password/change"})
    public StdData<?> changePassword(@RequestBody PasswordVO body) {
        User user = this.userRepository.findByName(body.getName());
        if (user.getPwdHash().equals(body.getOldPwdHash())) {
            user.setPwdHash(body.getPwdHash());
            this.userRepository.update((ObIdEntity)user);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/password/reset"})
    public StdData<?> resetPassword(@RequestBody PasswordVO body) {
        User user = this.userRepository.findByName(body.getName());
        user.setPwdHash(body.getPwdHash());
        this.userRepository.update((ObIdEntity)user);
        return StdData.ok().build();
    }

    @GetMapping(value={"/name/{name:.+}"})
    public StdData<?> findByName(@PathVariable String name) {
        User user = this.userRepository.findByName(name);
        return StdData.ok((Object)user);
    }

    @GetMapping(value={"/option"})
    public StdData<?> userSelect(@RequestBody(required=false) User body) {
        List users = this.userRepository.findAll((ObIdEntity)body);
        Map<String, List<User>> userMap = users.stream().collect(Collectors.groupingBy(User::getBuiltinRole));
        ArrayList<Options> optionGroup = new ArrayList<Options>();
        for (Map.Entry<String, List<User>> entry : userMap.entrySet()) {
            Options options = new Options();
            options.setKey((long)RoleEnum.valueOf((String)entry.getKey()).ordinal());
            options.setLabel(RoleEnum.valueOf((String)entry.getKey()).name());
            for (User user : entry.getValue()) {
                options.getOptions().add(new Option(user.getName(), user.getDisplayName()));
            }
            optionGroup.add(options);
        }
        return StdData.ok(optionGroup.stream().sorted(Comparator.comparing(Options::getKey).reversed()).collect(Collectors.toList()));
    }
}

