/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.FileOnline;
import com.digiwin.dap.middleware.domain.StdData;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping
public class FileViewController {
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileOnline fileOnline;

    @ResponseBody
    @GetMapping(value={"/api/dmc/v2/file/{bucket}/online/preview/url/{fileId}"})
    public StdData<?> getPreviewUrl(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        String previewUrl = this.fileOnline.getViewUrl(bucket, fileInfo, request);
        return StdData.ok(Collections.singletonMap("previewUrl", previewUrl));
    }

    @GetMapping(value={"/api/dmc/v2/file/{bucket}/online/preview/{fileId}"})
    public void preview(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        String previewUrl = this.fileOnline.getViewUrl(bucket, fileInfo, request);
        response.setStatus(302);
        response.sendRedirect(previewUrl);
    }

    @ResponseBody
    @GetMapping(value={"/api/dmc/v2/file/{bucket}/online/edit/url/{fileId}"})
    public StdData<?> getEditUrl(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        String editUrl = this.fileOnline.getEditUrl(bucket, fileInfo, request);
        return StdData.ok(Collections.singletonMap("editUrl", editUrl));
    }

    @GetMapping(value={"/api/dmc/v2/file/{bucket}/online/edit/{fileId}"})
    public void edit(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        String editUrl = this.fileOnline.getEditUrl(bucket, fileInfo, request);
        response.setStatus(302);
        response.sendRedirect(editUrl);
    }

    @Deprecated
    @GetMapping(value={"/api/dmc/v2/file/online/preview"})
    public void preview(@RequestParam String url, HttpServletResponse response) throws Exception {
        response.setStatus(302);
        response.sendRedirect(url);
    }
}

