/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1;

import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.DirectoryVO;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.annotation.UnSafe;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class DirectoryController {
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private DirectoryNodeService directoryNodeService;
    @Autowired
    private DirectoryCrudService directoryCrudService;

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=21)
    @PostMapping(value={"/buckets/{bucket}/directorys", "/myresources/directorys"})
    public ResponseEntity<?> create(@PathVariable(required=false) String bucket, @RequestBody DirInfo body) {
        this.fidCheckService.newDirCheck(bucket, body);
        body.setBucket(bucket);
        String dirId = this.directoryCrudService.insert((UuIdEntity)body);
        return ResponseEntity.ok(Collections.singletonMap("dirId", dirId));
    }

    @RoleAuthorize(admin=true, action=ActionEnum.Read, type=FileTypeEnum.Directory, order=1, dirIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/directorys/{dirId}", "/myresources/directorys/{dirId}"})
    public ResponseEntity<?> getDirInfo(@PathVariable(required=false) String bucket, @PathVariable String dirId) {
        UUID directoryId = IdUtil.getDirId((String)dirId);
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, directoryId);
        return ResponseEntity.ok((Object)dirInfo);
    }

    @RoleAuthorize(admin=true, dirIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/directorys/{parentId}/{dirName}", "/myresources/directorys/{parentId}/{dirName}"})
    public StdData<?> getDirInfoByName(@PathVariable(required=false) String bucket, @PathVariable String parentId, @PathVariable String dirName) {
        UUID dirParentId = IdUtil.getDirId((String)parentId);
        DirInfo dirInfo = this.directoryNodeService.findByName(bucket, dirParentId, dirName);
        return StdData.ok((Object)dirInfo);
    }

    @UnSafe
    @RoleAuthorize(admin=true)
    @GetMapping(value={"/buckets/{bucket}/directorys"})
    public ResponseEntity<?> listContents(@PathVariable(required=false, value="bucket") String bucket, @RequestBody(required=false) DirInfo body) {
        List dirInfos = body != null && StringUtils.hasText((String)body.getName()) ? this.directoryNodeService.findByNameLike(bucket, body.getName()) : this.directoryNodeService.findAll(bucket);
        return ResponseEntity.ok((Object)dirInfos);
    }

    @RoleAuthorize(admin=true, action=ActionEnum.Read, type=FileTypeEnum.Directory, order=1, dirIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/directorys/{dirId}/list", "/myresources/directorys/{dirId}/list"})
    public ResponseEntity<?> listContents(@PathVariable(required=false) String bucket, @PathVariable String dirId, @RequestParam(defaultValue="0") int sort, @RequestParam(defaultValue="asc") String type) {
        UUID directoryId = IdUtil.getDirId((String)dirId);
        List dirInfos = this.directoryNodeService.findByParentId(bucket, directoryId, BsonUtil.sort((int)sort, (String)type, (FileTypeEnum)FileTypeEnum.Directory));
        List fileInfos = this.fileNodeService.findByDirId(bucket, directoryId.toString(), BsonUtil.sort((int)sort, (String)type, (FileTypeEnum)FileTypeEnum.File));
        return ResponseEntity.ok((Object)new DirectoryVO(fileInfos, dirInfos));
    }

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=1, dirIndexes={1})
    @PostMapping(value={"/buckets/{bucket}/directorys/{dirId}/rename/{dirName}", "/myresources/directorys/{dirId}/rename/{dirName}"})
    public ResponseEntity<?> renameDirectory(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String dirName) {
        UUID directoryId = IdUtil.getDirId((String)dirId);
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, directoryId);
        if (dirInfo != null) {
            this.fidCheckService.modDirCheck(bucket, dirInfo, dirInfo.getParentId(), dirName);
            dirInfo.setName(dirName);
            this.directoryCrudService.update((UuIdEntity)dirInfo);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(admin=true, dirIndexes={1, 2})
    @PostMapping(value={"/buckets/{bucket}/directorys/{dirId}/isParentDirectory/{targetDirId}", "/myresources/directorys/{dirId}/isParentDirectory/{targetDirId}"})
    public ResponseEntity<?> isParentDirectory(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String targetDirId) {
        UUID id = IdUtil.getDirId((String)dirId);
        UUID targetId = IdUtil.getDirId((String)targetDirId);
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, targetId);
        if (dirInfo != null && (dirInfo.getParentId().equals(id) || id.equals(targetId))) {
            return ResponseEntity.ok((Object)true);
        }
        return ResponseEntity.ok((Object)false);
    }
}

