/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1;

import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.time.LocalDateTime;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileInfoController {
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;

    @RoleAuthorize(admin=true, action=ActionEnum.Read, order=1, fileIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/files/{fileId}/info", "/myresources/files/{fileId}/info"})
    public ResponseEntity<?> getFileInfo(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileId);
        this.fidCheckService.fillDirName(bucket, fileInfo);
        return ResponseEntity.ok((Object)fileInfo);
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/buckets/{bucket}/files/recently", "/myresources/files/recently"})
    public ResponseEntity<?> getFileInfoRecently(@PathVariable(required=false) String bucket) {
        Bson filter = Filters.gt((String)"modifyDate", (Object)LocalDateTime.now().minusMonths(1L));
        List fileInfos = this.fileNodeService.findByCondition(bucket, filter);
        this.fidCheckService.fillDirName(bucket, fileInfos);
        return ResponseEntity.ok((Object)fileInfos);
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/buckets/{bucket}/files/uncompleted", "/myresources/files/uncompleted"})
    public ResponseEntity<?> getFileInfoUncompleted(@PathVariable(required=false) String bucket) {
        Bson filter = Filters.eq((String)"completed", (Object)false);
        Bson sort = Sorts.descending((String[])new String[]{"modifyDate"});
        List fileInfos = this.fileNodeService.findByCondition(bucket, filter, sort);
        this.fidCheckService.fillDirName(bucket, fileInfos);
        return ResponseEntity.ok((Object)fileInfos);
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/metadata", "/myresources/files/{fileId}/metadata"})
    public ResponseEntity<?> updateFileMetadata(@PathVariable(required=false) String bucket, @PathVariable String fileId, @RequestBody Document metadata) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        fileInfo.setMetadata(metadata);
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        return ResponseEntity.ok().build();
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/fileInfo/matadata", "/myresources/files/{fileId}/fileInfo/metadata"})
    public ResponseEntity<?> updateFileInfoMetadata(@PathVariable(required=false) String bucket, @PathVariable String fileId, @RequestBody FileInfo body) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        fileInfo.setMetadata(body.getMetadata());
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        return ResponseEntity.ok().build();
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/rename/{newFileName:.+}", "/myresources/files/{fileId}/rename/{newFileName:.+}"})
    public ResponseEntity<?> renameFiles(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String newFileName) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        fileInfo.setFileName(newFileName);
        fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
        this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

