/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class ShareController {
    @Autowired
    private ShareCrudService shareCrudService;

    @RoleAuthorize
    @DeleteMapping(value={"/{bucket}/deleteShareFile/{shareId}", "/myresources/deleteShareFile/{shareId}"})
    public void deleteShareFile(@PathVariable(required=false) String bucket, @PathVariable UUID shareId) {
        this.shareCrudService.deleteById(bucket, shareId);
    }

    @GetMapping(value={"/{bucket}/findMyShareFiles", "/myresources/findMyShareFiles"})
    public ResponseEntity<?> getMyShareFiles(@PathVariable(required=false) String bucket) {
        bucket = TenantUtil.getBucketName((String)bucket);
        return ResponseEntity.ok((Object)this.shareCrudService.getMyShareFile(bucket));
    }
}

