/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.service.business.FileService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileCopyController {
    @Autowired
    private FileService fileService;

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=2, fileIndexes={1}, dirIndexes={2})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/copyto/directory/{targetDirId}", "/myresources/files/{fileId}/copyto/directory/{targetDirId}"})
    public ResponseEntity<?> copyFile(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String targetDirId) {
        String copyId = this.fileService.copyFile(bucket, IdUtil.uuid((String)fileId), IdUtil.getDirId((String)targetDirId));
        return ResponseEntity.ok(Collections.singletonMap("id", copyId));
    }

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=2, dirIndexes={1, 2})
    @PostMapping(value={"/buckets/{bucket}/directorys/{dirId}/copyto/{targetDirId}", "/myresources/directorys/{dirId}/copyto/{targetDirId}"})
    public ResponseEntity<?> copyDirectory(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String targetDirId) {
        String copyId = this.fileService.copyDir(bucket, IdUtil.getDirId((String)dirId), IdUtil.getDirId((String)targetDirId));
        return ResponseEntity.ok(Collections.singletonMap("dirId", copyId));
    }

    @RoleAuthorize(dirIndexes={2})
    @PostMapping(value={"/buckets/{bucket}/files/copy/batch/directory/{targetDirId}", "/myresources/files/copy/batch/directory/{targetDirId}"})
    public ResponseEntity<?> copyFile(@PathVariable(required=false) String bucket, @RequestBody BatchFid body, @PathVariable String targetDirId) {
        body.afterPropertiesSet();
        return ResponseEntity.ok((Object)this.fileService.batchCopy(bucket, body, IdUtil.getDirId((String)targetDirId)));
    }
}

