/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.entity.uuid.RecycleBin;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileDeleteController {
    @Autowired
    private FileRecycleService fileRecycleService;

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @DeleteMapping(value={"/buckets/{bucket}/files/{fileId}", "/myresources/files/{fileId}"})
    public ResponseEntity<?> deleteFile(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        RecycleBin recycleBin = this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
        return ResponseEntity.ok(Collections.singletonMap("recycleBinId", recycleBin == null ? "" : recycleBin.getId()));
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @DeleteMapping(value={"/buckets/{bucket}/files/{fileId}/force", "/myresources/files/{fileId}/force"})
    public ResponseEntity<?> deleteFileForce(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=1, dirIndexes={1})
    @DeleteMapping(value={"/buckets/{bucket}/directorys/{dirId}", "/myresources/directorys/{dirId}"})
    public ResponseEntity<?> deleteDirectory(@PathVariable(required=false) String bucket, @PathVariable String dirId) {
        RecycleBin recycleBin = this.fileRecycleService.removeDir(bucket, IdUtil.getDirId((String)dirId));
        return ResponseEntity.ok(Collections.singletonMap("recycleBinId", recycleBin == null ? "" : recycleBin.getId()));
    }

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/files/delete/batch", "/myresources/files/delete/batch"})
    public ResponseEntity<?> deleteManyFileInfo(@PathVariable(required=false) String bucket, @RequestBody BatchFid body) {
        body.afterPropertiesSet();
        for (String fileId : body.getFileIds()) {
            this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
        }
        for (String dirId : body.getDirIds()) {
            this.fileRecycleService.removeDir(bucket, IdUtil.getDirId((String)dirId));
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

