/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileDownloadController {
    @Autowired
    private FileDownloadService fileDownloadService;

    @RoleAuthorize(action=ActionEnum.Read, order=1, fileIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/files/{fileId}", "/myresources/files/{fileId}"})
    public void download(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        this.fileDownloadService.downloadFile(bucket, fileId, InlineAttachment.attachment, request, response);
    }

    @RoleAuthorize(action=ActionEnum.Read, order=1, fileIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/files/{fileId}/{position}/{length}", "/myresources/files/{fileId}/{position}/{length}"})
    public void downloadPart(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable long position, @PathVariable long length, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.fileDownloadService.downloadFile(bucket, fileId, position, length, request, response);
    }
}

