/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.dao.ShrinkCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.ImageFile;
import com.digiwin.dap.middleware.dmc.domain.ImageHandle;
import com.digiwin.dap.middleware.dmc.domain.ImageInfo;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.ImageShrink;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.ContentModerator;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.service.business.impl.FileUploadServiceDecryptedDecorator;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.coobird.thumbnailator.Thumbnails;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileImageController {
    private static final Logger logger = LoggerFactory.getLogger(FileImageController.class);
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private ShareCrudService shareCrudService;
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private FileDownloadService downloadService;
    @Autowired
    private ShrinkCrudService shrinkCrudService;
    @Autowired
    private BucketRepository bucketRepository;

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/images/upload", "/myresources/images/upload"})
    public Callable<StdData<?>> uploadImage(@PathVariable(required=false) String bucket, @RequestParam(defaultValue="0") Boolean shrink, @RequestParam(defaultValue="0") Integer width, @RequestParam(defaultValue="0") Integer height, @RequestHeader(value="digi-middleware-drive-arg") FileInfo body, @RequestHeader(value="digi-middleware-need-moderator", defaultValue="0") Boolean needModerator, HttpServletRequest req, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) throws Exception {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setWidth(width.intValue());
        imageInfo.setHeight(height.intValue());
        imageInfo.setShrink(shrink.booleanValue());
        imageInfo.setShare(true);
        ImageHandle imageHandle = new ImageHandle(imageInfo, body);
        ServletInputStream inputStream = req.getInputStream();
        return () -> {
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            FileInfo fileInfo = fileUploadServiceDecryptedDecorator.uploadFromStream(bucket, body, (InputStream)inputStream);
            ContentModerator.processSync((String)bucket, (FileInfo)fileInfo, (boolean)needModerator);
            ImageFile imageFile = this.getShrinkImage(bucket, imageHandle);
            List sharedFiles = this.shareCrudService.getShareFileByFileId(bucket, fileInfo.getId().toString());
            if (sharedFiles.isEmpty()) {
                SharedFile sharedFile = this.shareCrudService.shareFile(bucket, fileInfo.getId().toString());
                sharedFiles.add(sharedFile);
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("fileId", fileInfo.getId());
            result.put("originUrl", ((SharedFile)sharedFiles.get(0)).getUrl());
            result.put("shrinkId", imageFile.getFileId());
            result.put("shrinkUrl", imageFile.getShareUrl());
            return StdData.ok(result);
        };
    }

    @RoleAuthorize(fileIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}", "/myresources/images/{fileId}"})
    public Callable<StdData<?>> getImage(@PathVariable(required=false) String bucket, @PathVariable String fileId, @RequestParam(defaultValue="1") Boolean shrink, @RequestParam(defaultValue="1") Boolean share, @RequestParam(defaultValue="0") Integer width, @RequestParam(defaultValue="0") Integer height) throws Exception {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setWidth(width.intValue());
        imageInfo.setHeight(height.intValue());
        imageInfo.setShrink(shrink.booleanValue());
        imageInfo.setShare(share.booleanValue());
        ImageHandle imageHandle = new ImageHandle(imageInfo, fileInfo);
        return () -> {
            ImageFile imageFile;
            ImageShrink imageShrink = this.shrinkCrudService.findByProperty(bucket, fileId, width.intValue(), height.intValue());
            if (imageShrink != null) {
                FileInfo shrinkInfo = (FileInfo)this.fileNodeService.findById(bucket, IdUtil.uuid((String)imageShrink.getTargetId()));
                List sharedFiles = this.shareCrudService.getShareFileByFileId(bucket, imageShrink.getTargetId());
                if (shrinkInfo != null && !sharedFiles.isEmpty()) {
                    imageFile = new ImageFile();
                    imageFile.copy(shrinkInfo, (SharedFile)sharedFiles.get(0), imageInfo);
                } else {
                    imageFile = this.getShrinkImage(bucket, imageHandle);
                }
            } else {
                imageFile = this.getShrinkImage(bucket, imageHandle);
            }
            return StdData.ok((Object)imageFile);
        };
    }

    @RoleAuthorize(fileIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/{shrink}", "/myresources/images/{fileId}/{shrink}"})
    public StdData<?> getImage(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable Boolean shrink) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        ArrayList result = new ArrayList();
        if (shrink.booleanValue()) {
            List imageShrinks = this.shrinkCrudService.findBySourceId(bucket, fileId);
            imageShrinks.forEach(p -> {
                FileInfo shrinkInfo = (FileInfo)this.fileNodeService.findById(bucket, p.getTargetId());
                List sharedFiles = this.shareCrudService.getShareFileByFileId(bucket, p.getTargetId());
                sharedFiles.forEach(o -> result.add(new ImageFile(shrinkInfo, o, p.getProperty())));
            });
        } else {
            List sharedFiles = this.shareCrudService.getShareFileByFileId(bucket, fileInfo.getId().toString());
            sharedFiles.forEach(o -> result.add(new ImageFile(fileInfo, o, new Document())));
        }
        return StdData.ok(result);
    }

    private ImageFile getShrinkImage(String bucket, ImageHandle imageHandle) {
        boolean flag;
        ImageFile imageFile = new ImageFile();
        FileInfo fileInfo = imageHandle.getFileInfo();
        ImageInfo imageInfo = imageHandle.getImageInfo();
        boolean bl = flag = !imageInfo.isShrink() || imageInfo.getWidth() <= 0 && imageInfo.getHeight() <= 0;
        if (flag) {
            List sharedFiles = this.shareCrudService.getShareFileByFileId(bucket, fileInfo.getId().toString());
            if (sharedFiles.isEmpty()) {
                SharedFile sharedFile = this.shareCrudService.shareFile(bucket, fileInfo.getId().toString());
                sharedFiles.add(sharedFile);
            }
            imageFile.copy(fileInfo, (SharedFile)sharedFiles.get(0), imageInfo.isShare());
        } else {
            int width = imageInfo.getWidth();
            int height = imageInfo.getHeight();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                byte[] bytes = this.downloadService.downloadToBytes(bucket, fileInfo.getId().toString());
                if (width > 0 && height > 0) {
                    Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(bytes)}).size(width, height).keepAspectRatio(false).toOutputStream((OutputStream)outputStream);
                } else if (width > 0) {
                    Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(bytes)}).width(width).toOutputStream((OutputStream)outputStream);
                } else if (height > 0) {
                    Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(bytes)}).height(height).toOutputStream((OutputStream)outputStream);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BusinessException((ErrorHandler)I18nError.FILE_IMAGE_HANDLE_FAIL, new Object[]{fileInfo.getFileName()});
            }
            FileInfo shrinkInfo = fileInfo.clone();
            shrinkInfo.setId(UUID.randomUUID());
            shrinkInfo.setFileId(null);
            this.fileUploadService.uploadFromStream(bucket, shrinkInfo, (InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            String shrinkUrl = this.shareCrudService.shareFile(bucket, shrinkInfo.getId().toString()).getUrl();
            ImageShrink imageShrink = new ImageShrink();
            imageShrink.setSourceId(fileInfo.getId().toString());
            imageShrink.setProperty(new Document().append("width", (Object)width).append("height", (Object)height));
            imageShrink.setTargetId(shrinkInfo.getId().toString());
            imageShrink.setBucket(bucket);
            this.shrinkCrudService.insert((UuIdEntity)imageShrink);
            imageFile.copy(shrinkInfo, shrinkUrl, imageInfo);
        }
        return imageFile;
    }
}

