/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.service.business.FileService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileMoveController {
    @Autowired
    private FileService fileService;

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=2, fileIndexes={1}, dirIndexes={2})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/moveto/directory/{targetDirId}", "/myresources/files/{fileId}/moveto/directory/{targetDirId}"})
    public ResponseEntity<?> moveFile(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String targetDirId) {
        this.fileService.moveFile(bucket, IdUtil.uuid((String)fileId), IdUtil.getDirId((String)targetDirId));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=2, dirIndexes={1, 2})
    @PostMapping(value={"/buckets/{bucket}/directorys/{dirId}/moveto/{targetDirId}", "/myresources/directorys/{dirId}/moveto/{targetDirId}"})
    public ResponseEntity<?> moveDirectory(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String targetDirId) {
        this.fileService.moveDir(bucket, IdUtil.getDirId((String)dirId), IdUtil.getDirId((String)targetDirId));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(dirIndexes={2})
    @PostMapping(value={"/buckets/{bucket}/files/move/batch/directory/{targetDirId}", "/myresources/files/move/batch/directory/{targetDirId}"})
    public ResponseEntity<?> moveManyFileInfo(@PathVariable(required=false) String bucket, @RequestBody BatchFid body, @PathVariable String targetDirId) {
        body.afterPropertiesSet();
        for (String fileId : body.getFileIds()) {
            this.fileService.moveFile(bucket, IdUtil.uuid((String)fileId), IdUtil.getDirId((String)targetDirId));
        }
        for (String dirId : body.getDirIds()) {
            this.fileService.moveDir(bucket, IdUtil.getDirId((String)dirId), IdUtil.getDirId((String)targetDirId));
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

